from examples.hotpotqa.programs.operations.utils import parse_list_and_extract_logprobs, find_dependencies, replace_dependencies
from llm_graph_optimizer.graph_of_operations.types import ReasoningState


def prompter(question: str, dependency_answers: list[str]) -> str:
    dependencies_ids: list[int] = find_dependencies(question)
    if dependency_answers is None:
        dependency_answers = []
    replaced_question = replace_dependencies(question, {id: answer for id, answer in zip(dependencies_ids, dependency_answers)})
    examples = """Please generate the next decomposition in list format for a given question. In this decomposition, each item in the list is a sub-question of its parent to be able to answer the original question. #i refer to the answer of the index of the questions on the same level. This means there cannot be any # in the first question and no #2 in the second etc in the same list.
Q: When did the first large winter carnival take place in the city where CIMI−FM is licensed to broadcast?
A: ["Which city is CIMI−FM licensed to broadcast?", "When did the first large winter carnival take place in #1?"]
Q: What county is Hebron located in, in the same province the Heritage Places Protection Act applies to?
A: ["Which did Heritage Places Protection Act apply to the jurisdiction of?", "which country is Hebron, #1 located in?"]
Q: What weekly publication in the Connecticut city with the most Zagat rated restaurants is issued by university of America−Lite: How Imperial Academia Dismantled Our Culture's author?
A: ["Which university was the author of America−Lite: How Imperial Academia Dismantled Our Culture educated at?", "What city in Connecticut has the highest number of Zagat−rated restaurants?", "What is the weekly publication in #2 that is issued by #1?"]
Q: Which university was the author of America−Lite: How Imperial Academia Dismantled Our Culture educated at?
A: ["Who is the author of America−Lite: How Imperial Academia Dismantled Our Culture?", "Which university was #1 educated at?"]
Q: What did the publisher of Banjo−Tooie rely primarily on for its support?
A: ["What is the publisher of Banjo−Tooie?", "What did #1 rely primarily for its support on first−party games?"]
Q: In which county was the birthplace of the Smoke in tha City performer?
A: ["What's the birthplace of the Smoke in tha City performer?", "Which country is #1 located in?"]
Q: What's the birthplace of the Smoke in tha City performer?
A: ["Who is the performer of Smoke in tha City?", "Where was #1 born?"]
Q: What region of the state where Guy Shepherdson was born, contains SMA Negeri 68?
A: ["Where was Guy Shepherdson born?", "what region of the state is SMA Negeri 68 #1 located in?"]
Q: When did Britain withdraw from the country containing Hoora?
A: ["Which country is Hoora in?", "When did Britain withdraw from #1?"]
Q: How long is the US border with the country that borders the state where Finding Dory takes place?
A: ["Which country shares a border with the state where Finding Dory is supposed to take place?", "how long is the us border with #1?"]
Q: Which country shares a border with the state where Finding Dory is supposed to take place?"
A: ["where is finding dory supposed to take place", "which country shares a border with #1"]
Q: When did the first large winter carnival happen in Olivier Robitaille's place of birth?
A: ["Where was Olivier Robitaille born?", "when did the first large winter carnival take place in #1?"]
Q: When did Britain withdraw from the country where the village of Wadyan is found?
A: ["Which country is Wadyan in ?", "When did Britain withdraw from #1?"]
Q: How many countries in Pacific National University's continent are recognized by the organization that mediated the truce ending the Iran−Iraq war?
A: ["What continent is the country of Pacific National University located in?", "Who mediated the truce which ended the Iran-Iraq War?", "the #2 recognises how many regions in #1?"]
Q: What continent is the country of Pacific National University located in?
A: ["which country is Pacific National University located in?", "What continent is #1 in?"]
Q: When was Eritrea annexed by the Horn of Africa country where, along with Somalia and the country where Bissidiro is located, Somali people live?
A: ["Along with Kenya, the country where Bissidiro is located and Somalia, in what Horn of Africa country do Somali people live?", "When was Eritrea annexed by #1?"]
Q: Along with Kenya, the country where Bissidiro is located and Somalia, in what Horn of Africa country do Somali people live?
A: ["Which country is Bissidiro located in?", "Along with Kenya, #1 and Somalia, in what Horn of Africa country do Somali people live?"]
Q: What was used to launch the probe of the country where Gao is located to the planet where Hephaestus Fossae is found?
A: ["Where was Goa?", "Where is Hephaestus Fossae found?", "#1 's mangalyaan was sent to the #2 by launching what?"]
Q: Where is the lowest place in the country which, along with Eisenhower's VP's country, recognized Gaddafi's government early on?
A: ["What country is along with Eisenhower's VP's country, recognized Gaddafi's government early on?", "Where is the lowest place in the #1"]
Q: What country is along with Eisenhower's VP's country, recognized Gaddafi's government early on?
A: ["Eisenhower's vice president was a president of what country?", "Along with the #1 , what major power recognized Gaddafi's government at an early date?"]
Q: Eisenhower's vice president was a president of what country?
A: ["Who served as Eisenhower's vice president?", "#1 was a president of what country?"]
Q: When did the capital of Virginia moved from John Nicholas's birth city to Charles Oakley's alma mater's city?
A: ["Which city was Charles Oakley's university located in?", "Where was John Nicholas born?", "When did the capital of virginia moved from #2 to #1?"]
Q: Which city was Charles Oakley's university located in?
A: ["Which university was Charles Oakley educated at?", "Which city was #1 located in?"]
Q: How many people whose name new students were once called by others live in the South American country discovered by the country Cristiano Ronaldo plays for?
A: ["What is the South American country discovered by the country Cristiano Ronaldo plays for?", "What were new students once called by others?", "How many #2 live in #1 ?"]
Q: "What is the South American country discovered by the country Cristiano Ronaldo plays for?
A: ["What country does cristiano ronaldo play for?", "What South American country did #1 discover?"]
Q: When did the winners of the Battle of Borodino come to the place in which the island besides St. Barts granted COM status by France in 2007 is located?
A: ["The island besides St. Barts granted COM status by France in 2007 is located on which terrain feature?", "Who won the Battle of Borodino?", "when did the #2 come to the #1?"]
Q: The island besides St. Barts granted COM status by France in 2007 is located on which terrain feature?
A: ["What island besides St. Barts was granted COM status by France in 2007?", "#1 is located on which terrain feature?"]
Q: How many square miles is the source of the most legal immigrants to the location of Gotham's filming from the region where Andy from The Office sailed to?
A: ["What is the source of the most legal immigrants to the location of Gotham's filming from the region where Andy from The Office sailed to?", "How many square miles is #1?"]
Q: What is the source of the most legal immigrants to the location of Gotham's filming from the region where Andy from The Office sailed to?
A: ["where is the tv show gotham filmed at", "where did andy sail to in the office", "What nation provided the most legal immigrants to #1 in the #2 ?"]
Q: When did the capitol of Virginia move from Robert Banks' birthplace to the city sharing a border with Laurel's county?
A: ["What is the city sharing a border with Laurel's county?", "Where is Robert Banks' birthplace?", "When did the capitol of Virginia move from #1 to #2?"]
Q: What is the city sharing a border with Laurel's county?
A: ["What county is Laurel located in?", "What city shares a border with #1?"]
Q: An actor in Nowhere to Run is a national of a European country. That country's King Albert I lived during a major war that Italy joined in what year?
A: ["Albert I of the country which has the actor in Nowhere to Run lived during which war?", "When did Italy join #1?"]
Q: Albert I of the country which has the actor in Nowhere to Run lived during which war?
A: ["Tell me the country which has the actor in Nowhere to Run", "Albert I of #1 lived during which war?"]
Q: Tell me the country which has the actor in Nowhere to Run
A: ["Nowhere to Run's cast member is whom?", "What is the country of #1?"]
Q: """

    return examples + replaced_question

def parser(output: list) -> ReasoningState:
    parsed_data, avg_logprob =  parse_list_and_extract_logprobs(list(map(lambda x: x[0], output)), list(map(lambda x: x[1], output)))
    return {"subquestions": parsed_data, "question_decomposition_score": avg_logprob}