# Denoising diffusion models for graph generation


## Environment installation
  - Download anaconda/miniconda if needed
  - Create a rdkit environment that directly contains rdkit: `conda create -c conda-forge -n my-rdkit-env rdkit`
  - Install pytorch 1.10 or 1.11 (https://pytorch.org/)
  - Install pytorch-geometric. Your version should match the pytorch version that is installed (https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html)
  - Install other packages using the requirement file: `pip install -r requirements.txt`

## Run the code
  
  - All code is currently launched through `python3 main.py`. Check hydra documentation (https://hydra.cc/) for overriding default parameters.
  - To run the debugging code: `python3 main.py +experiment=debug.yaml`.
  - To run a code on only a few batches: `python3 main.py general.name=test`.
  - To run the continuous model: `python3 main.py model=continuous`
  - To run the discrete model: `python3 main.py`

To run the GG-GAN benchmarks:
```python dgd/main.py model=discrete general=general_nx general.gpus=1 dataset=nx_circle train.batch_size=32 train.progress_bar=false
python dgd/main.py model=discrete general=general_nx general.gpus=1 dataset=nx_small_squares train.batch_size=32 train.progress_bar=false
python dgd/main.py model=discrete general=general_nx general.gpus=1 dataset=comm20 train.batch_size=32 train.progress_bar=false```

  
## Using the Docker image

0. Install [docker+nvidia-docker](https://github.com/NVIDIA/nvidia-docker)
1. Do your edits to the files (if you add new files outside the directories `configs, analysis,datasets,diffusion,archives` or `models`, you will need to add the files/directories as well) and commit.
2. Rebuild + push the docker image to the registry with 
   1. `docker build -t graphgendiff:latest` .
3. Run with `docker run -e WANDB_API_KEY=$YOUR_API_KEY graphgendiff:latest` on local (TODO: GPU run command with nvidia-docker)

