from mcp.server.fastmcp import FastMCP 
import hashlib
import uvicorn

mcp = FastMCP("check_sig", host="127.0.0.1", port=9001)

@mcp.tool()
async def check(file_mame: str, sig: str) -> str:
    """
    check the signature of file using md5

    Args:
        file_name: the name of file
        sig: the predefined sig
    Returns:
        result of check
    """
    hash_ = hashlib.md5(open(file_mame,'rb').read()).hexdigest()
    if hash_ == sig:
        return "verified file"
    else:
        return "malicious file"

@mcp.tool()
async def compute(file_mame: str) -> str:
    """
    compute the signature of file using md5

    Args:
        file_name: the name of file
    Returns:
        result of check
    """
    hash_ = hashlib.md5(open(file_mame,'rb').read()).hexdigest()
    return hash_

uvicorn.run(mcp.streamable_http_app, host="127.0.0.1", port=9001)
