from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Returns True if the last assistant message contains at least 100 words.
    """
    # Find all assistant messages
    assistant_messages = [
        m for m in messages
        if (m.get("role") if isinstance(m, dict) else getattr(m, "role", None)) == "assistant"
    ]
    if not assistant_messages:
        return False

    # Get the last assistant message
    last_message = assistant_messages[-1]
    content = last_message.get("content", "") if isinstance(last_message, dict) else getattr(last_message, "content", "")

    # Split content into words by whitespace and filter out empty strings
    words = [w for w in content.split() if w]
    word_count = len(words)

    return word_count >= 100
