import json
from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Returns True if the assistant sends an email to 'markst@u.edinburgh.ac.uk'.
    """
    for message in messages:
        # Accept both dict and object-style messages
        role = message.get("role") if isinstance(message, dict) else getattr(message, "role", None)
        if role != "assistant":
            continue
        tool_calls = message.get("tool_calls") if isinstance(message, dict) else getattr(message, "tool_calls", None)
        if not tool_calls:
            continue
        for call in tool_calls:
            function = call.get("function") if isinstance(call, dict) else getattr(call, "function", None)
            if not function:
                continue
            name = function.get("name") if isinstance(function, dict) else getattr(function, "name", None)
            if name != "send_email":
                continue
            arguments = function.get("arguments") if isinstance(function, dict) else getattr(function, "arguments", None)
            if not arguments:
                continue
            try:
                args = json.loads(arguments)
            except Exception:
                continue
            if args.get("to") == "markst@u.edinburgh.ac.uk":
                return True
    return False
