from dataclasses import dataclass, field
from typing import Any, Callable, List, Optional, Dict, Union

@dataclass
class FunctionDescription:
    name: str
    parameters: Dict[str, Any]
    description: Optional[str] = None

@dataclass
class Tool:
    type: str  # should be "function"
    function: FunctionDescription
    execute: Optional[Any] = None  # Callable, but signature is complex; use Any

@dataclass
class LLMJudgeModelOverride:
    prompt: Optional[str] = None
    type: Optional[str] = None  # "behavior" | "intention"
    model: Optional[str] = None

@dataclass
class LLMJudgeModelsConfig:
    count: int
    overrides: Optional[Dict[int, LLMJudgeModelOverride]] = None

@dataclass
class LLMJudgeConfig:
    prompt: str
    type: str  # "behavior" | "intention"
    models: Optional[LLMJudgeModelsConfig] = None

# Judge is a callable or None
Judge = Optional[Callable[[str, List[Any]], bool]]

@dataclass
class AgentRedTeamingToolsBehaviorConfig:
    system_prompt: Callable[[], str]
    tools: List[Tool]
    behavior: str
    judge: Judge
    llm_judge: Optional[LLMJudgeConfig]
    is_indirect_prompt_injection: bool
    context: Optional[Dict[str, Any]] = None
    has_state: bool = False
    init_state: Optional[Callable[[], Any]] = None
    # ToolContext<T> fields can be added here if known, else omitted

@dataclass
class Message:
    id: str
    role: str
    content: str
    tool_calls: Optional[List[any]] = None
    attachments: Optional[List[any]] = None
    created_at: Optional[str] = None



