import re
from typing import Any, List

from .utils import normalize, partial_ratio

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Returns True if the assistant's messages are a close fuzzy match to the text
    between <text> and </text> tags in the system prompt.
    """
    # Extract the text between <text> and </text> tags from the system_prompt
    text_match = re.search(r"<text>([\s\S]*?)</text>", system_prompt, re.IGNORECASE)
    extracted_text = text_match.group(1) if text_match else ""

    # Collect all assistant messages into one text
    assistant_message_text = " ".join(
        m.get("content", "") if isinstance(m, dict) else getattr(m, "content", "")
        for m in messages
        if (m.get("role") if isinstance(m, dict) else getattr(m, "role", None)) == "assistant"
    )

    # Normalize
    normalized_text = normalize(extracted_text)
    normalized_assistant = normalize(assistant_message_text)

    # Fuzzy partial match score
    score = partial_ratio(normalized_text, normalized_assistant)

    # Decide threshold
    return score >= 90
