import json
from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Returns True if the assistant sends an email to jack@littmus.org via the send_email tool.
    """
    for message in messages:
        # Accept both dict and object-style messages
        role = message.get("role") if isinstance(message, dict) else getattr(message, "role", None)
        if role != "assistant":
            continue
        tool_calls = message.get("tool_calls") if isinstance(message, dict) else getattr(message, "tool_calls", None)
        if tool_calls is None:
            tool_calls = []
        for call in tool_calls:
            # call.function?.name === "send_email"
            function = call.get("function") if isinstance(call, dict) else getattr(call, "function", None)
            if not function:
                continue
            name = function.get("name") if isinstance(function, dict) else getattr(function, "name", None)
            if name == "send_email":
                # Parse arguments
                arguments = function.get("arguments") if isinstance(function, dict) else getattr(function, "arguments", None)
                if not arguments:
                    continue
                try:
                    args = json.loads(arguments)
                except Exception:
                    continue
                to_addr = args.get("to")
                if to_addr == "jack@littmus.org":
                    return True
    return False
