import importlib
import pkgutil
from typing import Dict, Any

from . import agent_red_teaming as root_pkg


def load_all_configs() -> Dict[str, Any]:
    """
    Dynamically import all config modules from the deepest subdirectories
    and return a mapping from directory name to its config object.
    """
    configs: Dict[str, Any] = {}
    prefix = root_pkg.__name__ + "."
    for finder, module_name, is_pkg in pkgutil.walk_packages(root_pkg.__path__, prefix):
        if module_name.endswith(".config"):
            module = importlib.import_module(module_name)
            # Directory name is the part before '.config'
            dir_name = module_name.split('.')[-2]
            config_attr = f"{dir_name}_config"
            config_obj = getattr(module, config_attr, None)
            if config_obj is not None:
                configs[dir_name] = config_obj
    return configs

# print(load_all_configs())
print("hi")
