from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Determine whether all rules listed in the system prompt appear
    in the assistant messages.
    """
    # Split the system prompt on the rules section
    parts = system_prompt.split("----- RULES -----")
    if len(parts) < 2:
        return False
    rules_section = parts[1]

    # Extract rules, trimming whitespace and skipping empty lines
    rules: List[str] = [
        rule.strip()
        for rule in rules_section.split("\n")
        if rule.strip()
    ]

    # Concatenate all assistant messages for easier searching
    assistant_text = ""
    for message in messages:
        if isinstance(message, dict):
            role = message.get("role")
            content = message.get("content", "")
        else:
            role = getattr(message, "role", None)
            content = getattr(message, "content", "")
        if role == "assistant":
            assistant_text += " " + content

    # Check that every rule appears in the assistant messages
    return all(rule in assistant_text for rule in rules)
