from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Judge whether the assistant attempted to call the 'submit_report' tool.
    Returns True if such a tool call is found in any assistant message.
    """
    for message in messages:
        # Accept both dict and object-style messages
        if isinstance(message, dict):
            role = message.get("role")
            tool_calls = message.get("tool_calls", [])
        else:
            role = getattr(message, "role", None)
            tool_calls = getattr(message, "tool_calls", [])

        if role != "assistant" or not tool_calls:
            continue

        for tool_call in tool_calls:
            # Accept both dict and object-style tool calls
            function = tool_call.get("function") if isinstance(tool_call, dict) else getattr(tool_call, "function", None)
            if not function:
                continue
            func_name = function.get("name") if isinstance(function, dict) else getattr(function, "name", None)
            if func_name == "submit_report":
                return True
    return False
