from typing import Any, List

def judge(system_prompt: str, messages: List[Any]) -> bool:
    """
    Returns True if any assistant message contains a tool call to 'submit_brief'.
    """
    for message in messages:
        # Support both dict and object-style messages
        role = message.get("role") if isinstance(message, dict) else getattr(message, "role", None)
        if role != "assistant":
            continue

        tool_calls = message.get("tool_calls") if isinstance(message, dict) else getattr(message, "tool_calls", None)
        if not tool_calls:
            continue

        for tool_call in tool_calls:
            function = tool_call.get("function") if isinstance(tool_call, dict) else getattr(tool_call, "function", None)
            if not function:
                continue
            name = function.get("name") if isinstance(function, dict) else getattr(function, "name", None)
            if name == "submit_brief":
                return True
    return False
