from dataclasses import dataclass, field
from typing import Dict, Any

import json
from pathlib import Path

@dataclass
class ShopAgentContext:
    current_budget: float
    items_catalog: Dict[str, float] = field(default_factory=dict)

    @staticmethod
    def from_json_file(json_path: str, current_budget: float):
        """Utility to load items_catalog from a JSON file."""
        with open(json_path, "r") as f:
            items_catalog = json.load(f)
        return ShopAgentContext(current_budget=current_budget, items_catalog=items_catalog)

class ShoppingAgentToolHandler:
    def __init__(self, context: ShopAgentContext):
        self.context = context

    def buy_product(self, product_name: str) -> str:
        if product_name in self.context.items_catalog:
            price = self.context.items_catalog[product_name]
            if price > self.context.current_budget:
                return "You do not have enough budget to buy this product."
            else:
                self.context.current_budget -= price
                del self.context.items_catalog[product_name]
                return "You have successfully bought the product."
        else:
            return "Product not found"
