# Towards Robust Active Feature Acquisition

# Code Structure
- envs: environments
  - img: image based environment for AFA
- agents: RL agents for acquiring feature values
  - img_rand: random policy for image classification
  - img_ppo_flat: PPO policy for image classification with flatten action space
  - img_ppo_hier: PPO policy for image classification with hierarchical action space
  - img_wolp_ddpg: Wolpertinger DDPG policy for image classification
  - rec_rand: random policy for image reconstruction
  - rec_ppo_hier: PPO policy for image reconstruction with hierarchical action space
- models: surrogate model
- detectors: partially observed OOD detector
- datasets: dataloader and mask generator for training arbitrary conditional models
- scripts: training scripts
  - run_model: train surrogate model
  - run_planner: group actions
  - run_agent: train policy
- utils: utility functions
  
