# Enable subset for hyperparameter optimization
export LMMS_EVAL_ENABLE_SUBSET=False
# export LMMS_EVAL_RANDOM_SEED=42
# export LMMS_EVAL_SUBSET_RATIO=0.2

### -------------------------- POPE (coco) --------------------------
# vanilla
CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
	--num_processes=1 \
	-m lmms_eval \
	--model qwen2_5_vl \
	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
	--tasks pope \
	--batch_size 1 \
	--log_samples \
	--log_samples_suffix qwen2_5_vl_7b_instruct_pope \
	--output_path ./logs/ \
	--process_with_media 

# # Truthfulness score (ver.10,11) -> Head Gate (contrast) - do not use ver.12
# # ver.10 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_truthful_head_ver10_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_truthful_head_ver10_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# # ver.11 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_truthful_head_ver11_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_truthful_head_ver11_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	




# ### -------------------------- POPE (aokvqa) --------------------------
# # vanilla
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_aokvqa \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_aokvqa \
# 	--output_path ./logs/ \
# 	--process_with_media 

# # Truthfulness score (ver.7,8,9) -> Head Gate (contrast)
# # ver.10 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_aokvqa_truthful_head_ver10_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_aokvqa_truthful_head_ver10_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_aokvqa_truthful_head_ver11_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_aokvqa_truthful_head_ver11_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	







# ### -------------------------- POPE (gqa) --------------------------
# # vanilla
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_gqa \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa \
# 	--output_path ./logs/ \
# 	--process_with_media 

# # Truthfulness score (ver.7,8,9) -> Head Gate (contrast)
# # ver.10 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_gqa_truthful_head_ver10_norm_03 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver10_norm_03 \
# 	--output_path ./logs/ \
# 	--process_with_media 


# # ver.11 (norm, cont)	
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks pope_gqa_truthful_head_ver11_norm_03 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver11_norm_03 \
# 	--output_path ./logs/ \
# 	--process_with_media 


# Extra hyperparams search
CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
	--num_processes=1 \
	-m lmms_eval \
	--model qwen2_5_vl \
	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
	--tasks pope_gqa_truthful_head_ver10_norm_04 \
	--batch_size 1 \
	--log_samples \
	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver10_norm_04 \
	--output_path ./logs/ \
	--process_with_media 

CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
	--num_processes=1 \
	-m lmms_eval \
	--model qwen2_5_vl \
	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
	--tasks pope_gqa_truthful_head_ver10_norm_05 \
	--batch_size 1 \
	--log_samples \
	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver10_norm_05 \
	--output_path ./logs/ \
	--process_with_media 


CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
	--num_processes=1 \
	-m lmms_eval \
	--model qwen2_5_vl \
	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
	--tasks pope_gqa_truthful_head_ver11_norm_04 \
	--batch_size 1 \
	--log_samples \
	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver11_norm_04 \
	--output_path ./logs/ \
	--process_with_media 

CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
	--num_processes=1 \
	-m lmms_eval \
	--model qwen2_5_vl \
	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
	--tasks pope_gqa_truthful_head_ver11_norm_05 \
	--batch_size 1 \
	--log_samples \
	--log_samples_suffix qwen2_5_vl_7b_instruct_pope_gqa_truthful_head_ver11_norm_05 \
	--output_path ./logs/ \
	--process_with_media 










# ### -------------------------- CHAIR (chair_max64) --------------------------
# # vanilla
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# Truthfulness score (ver.7,8,9) -> Head Gate (contrast)
# ver.10 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_norm_01 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_norm_01 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_norm_03 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_norm_03 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_cont_45 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_cont_45 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_cont_60 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_cont_60 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver10_cont_75 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver10_cont_75 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# ver.11 (norm, cont)
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_norm_01 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_norm_01 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_norm_02 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_norm_02 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_norm_03 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_norm_03 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_cont_45 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_cont_45 \
# 	--output_path ./logs/ \
# 	--process_with_media 

# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_cont_60 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_cont_60 \
# 	--output_path ./logs/ \
# 	--process_with_media 
	
# CUDA_VISIBLE_DEVICES=0 python3 -m accelerate.commands.launch \
# 	--num_processes=1 \
# 	-m lmms_eval \
# 	--model qwen2_5_vl \
# 	--model_args pretrained=Qwen/Qwen2.5-VL-7B-Instruct,attn_implementation=eager \
# 	--tasks chair_max64_truthful_head_ver11_cont_75 \
# 	--batch_size 1 \
# 	--log_samples \
# 	--log_samples_suffix qwen2_5_vl_7b_instruct_chair_max64_truthful_head_ver11_cont_75 \
# 	--output_path ./logs/ \
# 	--process_with_media 
