# sd
#DATA=/data/ruohongz/data2
#RES=/data/ruohongz/XMTC/saved

# sa
DATA=/usr1/ruohongz/XMTC/data
RES=/usr1/ruohongz/XMTC/saved

DATANAME=AmazonCat-13K
GPU=${1:-0,1}
model=${2:-xlnet}
model_name=${3:-xlnet-base-cased}
run_id=${4:-tmp}
#cmd=$5
#num_layer=${5:-12}
num_layer=${5:-12}
cmd=$6

# model, model name
# xlnet, xlnet-base-cased
# roberta, roberta-base
# roberta, distilroberta-base
# bert, bert-base-cased
# distilbert, distilbert-base-cased

python main.py \
--data_dir $DATA/$DATANAME \
--output_dir $RES/$DATANAME/${model_name}.${run_id} \
--log_dir $RES/log/${DATANAME}.${model_name}.${run_id}.txt \
--model_type $model \
--model_name_or_path $model_name \
--task_name $DATANAME \
--overwrite_output_dir \
--per_gpu_train_batch_size=12 \
--per_gpu_eval_batch_size=24 \
--learning_rate_x 5e-5 \
--learning_rate_h 1e-4 \
--learning_rate_a 2e-3 \
--num_train_epochs 8.0 \
--log_dir $RES/log/${DATANAME}.${model_name}.${run_id}.txt \
--logging_steps 500 \
--save_steps 15000 \
--last_hidden_size 768 \
--gpu $GPU --seed 428 \
--do_eval --eval_checkpoints last \
--save result_top --mode dev \
--max_seq_length 192  \
$cmd \
--label_suffix full \
--num_hidden_layers $num_layer \
#--attention_probs_dropout_prob 0 --hidden_dropout_prob 0 \

