# Anonymized RL Training Library

This repository contains the anonymized supplementary materials for our submission. It provides the implementation of a reinforcement-learning training stack for large language models together with example launch scripts used in our experiments.

## Repository Layout
- `verl/`: core library implementation.
- `examples/`: launch scripts and configuration snippets for the reported experiments.
- `tests/`: unit tests covering the execution flow and key utilities.
- `scripts/`: helper utilities used to reproduce the reported runs.

## Getting Started
1. Create a Python environment with version 3.10 or newer.
2. Install the package in editable mode:
   ```bash
   pip install -e .
   ```
3. Review `examples/` for experiment-specific overrides. Paths that point to our internal storage have been redacted and should be updated to match your environment.

## Notes
- All organisation-specific references, credentials, and telemetry data have been removed to preserve anonymity.
- Optional integrations that depend on proprietary services are disabled by default. Replace the placeholders with your own services if needed.

## License
The source code is distributed under the Apache 2.0 license. See `LICENSE` for details.
