## Subjective Learning for Open-Ended Data

The PyTorch implementations of OSL on regression and Fashion Product Images classification are provided here. The CIFAR-100 classification task needs extra pre-trained backbones of DenseNet-L190-k40, which will be released if the paper is accepted.

### Dependencies
Python3 and some basic libraries are needed:  
- torch 1.7.1  
- torchvision  
- numpy  
- matplotlib  
- PIL  
- skimage  

### Regression
Most hyper-parameters on datasets and the algorithm are shown on the beginning of the file, and a formal version with argparse will be released after acceptance.

#### Run
```bash
python OSL_FUNC.py
```

### Fashion Product Images
#### Dataset Download
The dataset can be directly downloaded from Kaggle. Both [high-resolution](https://www.kaggle.com/paramaggarwal/fashion-product-images-dataset) and [low-resolution](https://www.kaggle.com/paramaggarwal/fashion-product-images-small) datasets are available.

#### Preprocess
Please unzip the dataset, and use "fashion-preprocess.py" to filter and padding the origal data.
Note: the "csv_path" in the file should be changed to your personal directory.
```bash
python Support/fashion-preprocess.py
```

The data lists used in our experiment are also attached. Please put them in the same directory with your dataset, e.g. "Your_Dir/fashion-dataset/".
```
list_test_mix_all.txt
list_train_mix_all.txt
```

#### Run
``` bash
python OSL_Fashion.py
```