# **RECAP** 

> RECAP: REwriting Conversations for Intent Understanding in Agentic Planning 📄 

Understanding user intent is essential for effective planning in conversational assistants, particularly those powered by large language models (LLMs) coordinating multiple agents. However, real-world dialogues are often ambiguous, underspecified, or dynamic, making intent detection a persistent challenge. Traditional classification-based approaches struggle to generalize in open-ended settings, leading to brittle interpretations and poor downstream planning. 

We propose RECAP (REwriting Conversations for Agent Planning), a new benchmark designed to evaluate and advance intent rewriting, reframing user-agent dialogues into concise representations of user goals. RECAP captures diverse challenges such as ambiguity, intent drift, vagueness, and mixed-goal conversations. Alongside the dataset, we introduce an LLM-based evaluator that assesses planning utility given the rewritten intent. Using RECAP, we develop a prompt-based rewriting approach that outperforms baselines. We further demonstrate that fine-tuning two DPO-based rewriters yields additional utility gains. Our results highlight intent rewriting as a critical and tractable component for improving agent planning in open-domain dialogue systems.

## Dataset

We provide the dataset in `data/recap.json`

## Set Up Environment

```
$ conda create -n ENV_NAME python=3.9
$ conda activate ENV_NAME
```

Set environment variables `OPENAI_API_KEY` to your OpenAI API key and an optional `OPENAI_ORGANIZATION`

```
echo "export OPENAI_API_KEY=<your_key>" >> ~/.zshrc
echo "export OPENAI_ORGANIZATION=<org_key>" >> ~/.zshrc
```

## Install Requirements

```
$ pip install -r requirements.txt
```

## Synthetic Data Generation

We provide our generated and vetted dataset. 
You can generate further instances:

```
$ python src/synthetic_data_generation.py
```

## Rewriting User Intent

Use one of our proposed prompt-based rewriter models. You may also train your own rewriter model, following the prompts, models & hyperparameters specified in the paper. 

```
$ python src/rewriter.py
```

## Planner

Generate plans using the rewritten input. 

```
$ python src/planner.py
```