from pydantic import BaseModel
from typing import List

class Node(BaseModel):
    '''
    id: node id
    name: node name i.e. task
    '''
    id: int
    name: str

class LLMPlan(BaseModel):
    '''
    nodes: list of nodes
    edges: list of edges, where each instance [i,j] denotes an edge between nodeᵢ and nodeⱼ
    '''
    nodes: List[Node]
    edges: List[List[int]]