REWRITE_PROMPTS = {
    "dummy": "",
    "basic_summarizer": (
        "Summarize the following USER-AGENT conversation\n"
        "Conversation:\n{conversation}"
    ),
    "advanced_summarizer": (
        "Summarize the following USER-AGENT conversation into a single, concise sentence describing the user's intended task.\n"
        "The summary should reflect the user's goal or intent, in an instruction style.\n"
        "The user's intent may be changed completely i.e. shifted or it may be updated with further specifications for the original intent. Ensure to capture the latest user intent with only the necessary specifications.\n"
        "Filter out any noise or irrelevance in the input.\n"
        "Do not introduce new information. Only include what is stated or clearly implied, make assumptions only if necessary.\n"
        "Conversation:\n{conversation}"
    ),
}

PLAN_PROMPT = """
You are a planner responsible for creating high-level plans to solve any task. Understand the user intent from the input and plan accordingly. Consider breaking down complex tasks into subtasks.

Represent your plan as a graph where each node corresponds to a step, and each edge represents a dependency between two steps.
If a node requires the output from a previous node as an input, ensure it is included in the edge list.

The output should be structured in the following JSON format:
'nodes': <list of JSON nodes with keys 'id': <node id as integer>, 'name': <sub-task node name>>,
'edges': <list of tuples [node_id, node_id]>

Input: {input}
"""

PAIRWISE_EVALUATION_PROMPT = '''
You will be given a task-oriented dialogue between a USER and an AGENT as well as two plans. Your task is to choose the plan that better addresses the user's intent.

Note:
1. In some cases, the user's intent may be fully clear through the conversation (e.g., "For dinner, I want to cook white sauce pasta with chicken").
2. While in other instances, few aspects of the user's intent remain vague (e.g., "I want to have pasta for dinner").
3. In some cases, the user may backtrack on their initial query and ask help regarding a different task (e.g., the user initially asks the agent to help find restaurants with Japanese cuisine, but later decides they want Italian cuisine instead).
4. Furthermore, the user may provide details which may seem as a shift of their intent, but is only a further specification of their previous intent.
5. In some cases, the user may provide multiple tasks to the agent (e.g., "Find me programming resources for Web Development and Mobile App Development").

Please refer to the rubrics below when conducting the comparison: 

latest_intent: A good plan should fulfill the user's updated goals/intent from the conversation.
fabrication: A good plan should be accurate and not include unnecessary, repetitive or false tasks.
task_granularity: A good plan should provide more specific and detailed steps.
task_completeness: A good plan should include all necessary steps to achieve the user goal.
logical_order: A good plan should arrange tasks in a coherent, logical sequence. If tasks can be done in parallel, they should be done so for better efficiency.

The plans are evaluated on their ability to fulfill the above rubrics. Both plans are considered equally good when they are equally capable of fulfilling the above rubrics. In that case, output TIE.

Conversation:
{conversation}

Plan A:  
{planA}  

Plan B:  
{planB}  

Which plan better fulfills the user's request? Reply with 'A', 'B', or 'TIE'.

Your answer should be in JSON format with keys:
choice: <A or B or tie>
'''

CHALLENGE_PROMPTS = {
    "intent_shift": "The user's intent should shift partway through the conversation.",
    "noisy_data": "Include real-life noise such as greetings, small talk, or irrelevant details.",
    "underspecified_intent": "The user's goal should be vague or incomplete, requiring inference.",
    "multi_intent": "The user should express multiple distinct intents, possibly in the same turn.",
    "perfect_intent": "The user's goal should be clear, unambiguous, and fully specified."
}

# For IN3 data modification
CONVERSATION_GENERATOR_PROMPT = '''
You will be provided a task sentence and some missing details as a list. Each missing detail has an inquiry and corresponding options. 
Your job will be to convert this to a friendly User-Agent conversation. The User begins conversation with the task. The Agent responds with each missing detail inquiry one at a time, and the User responds with the option as response.

Task: {task}
Missing Details: {missing_details}

Output Format: 
conversation = [
"USER: <user_text>",
"AGENT: <user_text>",
"USER: <user_text>",...
]
'''