#!/bin/bash
HASH=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 4 | head -n 1)
GPU=$1
name=${USER}_GPU_${GPU}_${HASH}

echo "Launching container named '${name}' on GPU '${GPU}'"
# Launches a docker container using our image, and runs the provided command

if hash nvidia-docker 2>/dev/null; then
  cmd=nvidia-docker
else
  cmd=docker
fi

# --user $(id -u):$(id -g) \
NV_GPU="$GPU" ${cmd} run -d \
    --name $name \
    -v `pwd`:/Meta-Offline-RL \
    -v /data/brown/conlu/:/data_mount/ \
    -e PYTHONPATH='/Meta-Offline-RL' \
    -e LOCAL_LOG_DIR='/Meta-Offline-RL/data' \
    -t conlu/mujoco200mb \
    ${@:2}
