import numpy as np


def ackley53(ht_list, X):
    assert len(ht_list) == 50
    X_aug = np.hstack((np.array(ht_list), X))
    a = 20
    b = 0.2
    c = 2 * np.pi
    sum_sq_term = -a * np.exp(-b * np.sqrt(np.sum(np.square(X_aug)) / 53))
    cos_term = -1 * np.exp(np.sum(np.cos(c * np.copy(X_aug)) / 53))
    result = a + np.exp(1) + sum_sq_term + cos_term
    return result


if __name__ == '__main__':
    ht = [0] * 50
    X = np.random.rand(3)
    print(ackley53(ht, X))