## Pipeline Tutorial

```
cd datagen
```

### Step 1: Question Synthesis

**1.1 Generate Question Prompts**

```
Example Usage:

1. Single Server Mode (tools from one server per question):
   1.1. Random sampling (default) - 1000 questions from random servers:
        python step1.1_gen_questions.py --total_prompts 1000 --sampling_strategy random
   
   1.2. Uniform sampling - 5 questions per server (total = 5 * num_servers):
        python step1.1_gen_questions.py --sampling_strategy uniform --samples_per_server 5
   
   1.3. Power law sampling - favors popular servers based on usage rank:
        python step1.1_gen_questions.py --total_prompts 2000 --sampling_strategy power_law
   
   1.4. Featured sampling - only select from featured servers:
        python step1.1_gen_questions.py --total_prompts 1000 --sampling_strategy featured
   
   1.5. Generate questions for 2-tool scenarios with uniform sampling:
        python step1.1_gen_questions.py --num_tools 2 --sampling_strategy uniform --samples_per_server 10

2. Multi-Server Mode (tools from multiple servers per question):
   2.1. Random server combinations:
        python step1.1_gen_questions.py --mode multi_server --num_tools 2 --total_prompts 1000
   
   2.2. Servers from same category (same primary label):
        python step1.1_gen_questions.py --mode multi_server --num_tools 3 --multi_server_allocation_strategy same_primary_label
   
   2.3. Servers from different categories (different primary labels):
        python step1.1_gen_questions.py --mode multi_server --num_tools 3 --multi_server_allocation_strategy different_primary_labels
   
   2.4. LLM-driven server selection from featured servers (brainstorm context first):
        python step1.1_gen_questions.py --mode multi_server --num_tools 3 --multi_server_allocation_strategy random_featured
   
   2.5. Multi-server with custom server allocation:
        python step1.1_gen_questions.py --mode multi_server --num_tools 4 --multi_server_allocated_servers 3 --total_prompts 500

Key Parameters:
- --sampling_strategy: Controls server selection (random/uniform/power_law/featured) - ONLY for single_server mode
- --mode: single_server (individual servers) vs multi_server (server combinations)  
- --multi_server_allocation_strategy: For multi_server mode (random/same_primary_label/different_primary_labels/random_featured)
- --num_tools: Number of tools to include in each prompt
- --samples_per_server: For uniform sampling, questions per server
```

**1.2 Generate Questions**

You can choose different models for generating questions in this step.

```
bash step1.2_completion.sh {Question File Generated From Step 1.1} {Model Name}
```

**1.3 Process Completion**

```
python step1.3_process_completion.py --input_file {Response File Generated From Step 1.2}
```

### Step 2: Question Quality Check

**2.1 Generate Question Quality Check Prompts**

```
python step2.1_question_quality_check.py --input_file {File Generated From Step 1.3}
```

**2.2 Generate Question Quality Check Responses**

By default, we use quantized Kimi-K2 (`RedHatAI/Kimi-K2-Instruct-quantized.w4a16`) for quality annotation.

```
step2.2_completion_quality_check.sh {File Generated From Step 2.1}
```

**2.3 Process Completion**

```
python step2.3_process_completion.py --input_file {Response File Generated From Step 2.2}
```

### Step 3: Generate Agentic Trajectories

**3.1 Generate Agent Trajectories via Qwen/OpenAI Agents**

```
bash step3.1_completion_agent.sh {File Generated From Step 2.3}
```

**3.2 Process Completion**

This step will apply rule-based filtering to keep only high quality trajectories

```
python step3.2_process_completion.py --input_file {Response File Generated From Step 3.1}
```

### Step 4: Response Quality Check

**4.1 Generate Response Quality Check Prompts**

```
python step4.1_response_quality_check.py --input_file {File Generated From Step 3.2}
```

**4.2 Generate Response Quality Check Responses**

By default, we use quantized OSS-120B (`openai/gpt-oss-120b`) for response annotation.

```
step4.2_completion_response_check.sh {File Generated From Step 4.1}
```

**4.3 Process Completion**

```
python step4.3_process_completion.py --input_file {Response File Generated From Step 4.2}
```