# Safe Multi-Agent Isaac Gym Benchmark (Safe MAIG)

Safe Multi-Agent Isaac Gym benchmark is for safe multi-agent reinforcement learning research.



***


### About this repository

This repository is an extention of [DexterousHands](https://github.com/PKU-MARL/DexterousHands) which is from PKU MARL research team, Safe MAIG contains complex dexterous hand RL environments for the NVIDIA Isaac Gym high performance environments described in the NeurIPS 2021 Datasets and Benchmarks [paper.](https://openreview.net/forum?id=fgFBtYgJQX_)

:star2: This repository is under actively development. We appreciate any constructive comments and suggestions. If you have any questions, please feel free to email <gshangd[AT]foxmail.com>.


## Installation

Details regarding installation of IsaacGym can be found [here](https://developer.nvidia.com/isaac-gym). **We currently support the `Preview Release 3` version of IsaacGym.**

### Pre-requisites

The code has been tested on Ubuntu 18.04 with Python 3.7. The minimum recommended NVIDIA driver version for Linux is `470` (dictated by support of IsaacGym).

It uses [Anaconda](https://www.anaconda.com/) to create virtual environments. To install Anaconda, follow instructions [here](https://docs.anaconda.com/anaconda/install/linux/).

Ensure that Isaac Gym works on your system by running one of the examples from the `python/examples`  directory, like `joint_monkey.py`. Follow troubleshooting steps described in the Isaac Gym Preview  install instructions if you have any trouble running the samples.

### install this repo
Once Isaac Gym is installed and samples work within your current python environment, install this repo:

```bash
pip install -e .
```

## Running the benchmarks

To train your first policy, run this line:

```bash
python train.py --task=ShadowHandOver --algo=macpo
```
If you want to turn off the video, set headless as True, e.g., 

```bash
python train.py --task=ShadowHandOver --algo=macpo --headless=True
```

You can change the settings or hyperparameters of algorithms or tasks in /Safe-Multi-Agent-Isaac-Gym/dexteroushandenvs/cfg.

## Select an algorithm

To select an algorithm, pass `--algo=/mappo/happo/macpo/mafocops/mappolag` 
as an argument:

```bash
python train.py --task=ShadowHandOver --algo=macpo
```

