import matplotlib.pyplot as plt
import numpy as np
import pandas as pd


p_metric = 'wasserstein'

""" experiment_results_linear = {
    'original': {'precision': [0.8911651728553137, 0.8780025284450064, 0.8788449466415568, 0.8705080545229245, 0.8732042473454091, 0.8823159219634991, 0.8678090575275398, 0.878125, 0.8602409638554217, 0.8813451776649747], 'recall': [0.9267643142476698, 0.9247669773635153, 0.9320905459387483, 0.9354194407456724, 0.9307589880159787, 0.933422103861518, 0.9440745672436751, 0.9354194407456724, 0.9507323568575233, 0.9247669773635153], 'auroc': [0.7926994262001401, 0.7686083882801513, 0.7722701725677679, 0.7578703629431173, 0.7615642329638128, 0.7789600479146948, 0.7551698137423195, 0.7719265878427157, 0.7424344515211312, 0.7746324846656935], 'dp': [0.19983505450372918, 0.1904594341496637, 0.21425909361955875, 0.14331433586746567, 0.17789586433654225, 0.19466706596212846, 0.16569873621155673, 0.19869640303801228, 0.14793428938080733, 0.18152448168601676], 'ftu': [0.02849999999999997, 0.07050000000000001, 0.021499999999999964, 0.04149999999999998, 0.00649999999999995, 0.01749999999999996, 0.031000000000000028, 0.044499999999999984, 0.01200000000000001, 0.06000000000000005], 'etasq': [], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
    # 'decaf_dp': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
    'fdami_linear_dp_1': {'precision': [0.9051436205744823, 0.8903448275862069, 0.9107883817427386, 0.9055823569951758, 0.9070247933884298, 0.9184820801124385, 0.8947368421052632, 0.9125946317962835, 0.9158415841584159, 0.9128571428571428], 'recall': [0.9021304926764314, 0.859520639147803, 0.8768308921438083, 0.8748335552596538, 0.8768308921438083, 0.87017310252996, 0.8828229027962716, 0.8828229027962716, 0.8621837549933422, 0.8508655126498003], 'auroc': [0.8084949652137177, 0.770121765357034, 0.8088973737827475, 0.799866576826614, 0.8028732773972053, 0.8186206878111647, 0.7847849453740394, 0.8139014112374932, 0.8116139658500848, 0.8029427964855428], 'dp': [0.2241286574870912, 0.27270921422287797, 0.28848017292784733, 0.19156289684637529, 0.2575691728234102, 0.25403964957143976, 0.22105340054057998, 0.261736086609348, 0.2699151536137214, 0.2750101237545557], 'ftu': [0.05049999999999999, 0.09550000000000003, 0.06700000000000006, 0.008500000000000063, 0.07399999999999995, 0.056499999999999995, 0.08399999999999996, 0.031000000000000028, 0.09750000000000003, 0.08099999999999996], 'etasq': [0.1871672201663761, 0.1879616412862334, 0.1878726382609082, 0.1873536323289495, 0.18811084211934398, 0.1879130982882065, 0.18623328860276325, 0.1867796989739533, 0.18702852146770332, 0.1861466710273923], 'wasserstein': [0.13272159531932354, 0.13248439406574053, 0.1329900301509554, 0.13286156320999293, 0.13278955572325613, 0.13281220240820785, 0.13273473340691105, 0.1326705818771613, 0.13270914591528726, 0.1329853954011302], 'diff_mean': [20.062812292815927, 20.146596206549987, 20.10218575961741, 20.147177875556253, 20.13848181912235, 20.16399572118542, 20.161660655225944, 20.114858629908525, 20.15157928696261, 20.160960049633548], 'overlap_min': [-1.7431913307623468, -1.71900285540189, -1.751803105063317, -1.7788127190118823, -1.7945330314761578, -1.8284726494012993, -1.7546422634186383, -1.8152677537736137, -1.8003171090436902, -1.7620964420345298]},
    'fdami_linear_dp_2': {'precision': [0.9325153374233128, 0.9055232558139535, 0.9299763965381589, 0.9244992295839753, 0.9080056179775281, 0.9199428162973553, 0.931924882629108, 0.9376026272577996, 0.9213066072754269, 0.9321766561514195], 'recall': [0.8095872170439414, 0.829560585885486, 0.7869507323568575, 0.7989347536617842, 0.8608521970705726, 0.8568575233022636, 0.7929427430093209, 0.7603195739014648, 0.8262316910785619, 0.7869507323568575], 'auroc': [0.8164401948673523, 0.7842582045893294, 0.8041179364595532, 0.8010738025337034, 0.7988999941176157, 0.8159789624543445, 0.809121973914299, 0.8038545660671983, 0.806690142728036, 0.8071299846523243], 'dp': [0.3111911933448077, 0.2573512301711173, 0.3108415324985092, 0.26876809790004674, 0.27255606916623865, 0.2363240329465549, 0.3011724742493973, 0.3680247349167146, 0.28333639433858315, 0.2972868337790753], 'ftu': [0.0495000000000001, 0.027999999999999914, 0.04149999999999998, 0.07550000000000001, 0.09999999999999998, 0.05249999999999999, 0.019000000000000017, 0.057499999999999996, 0.10749999999999993, 0.10449999999999993], 'etasq': [0.1884794656665047, 0.18510595736118868, 0.18579396082867622, 0.18599255634279777, 0.1875167898877669, 0.18725014019030659, 0.18757667248039023, 0.1879486106807517, 0.18730542420277113, 0.18521796150125588], 'wasserstein': [0.22813429406453023, 0.2282188565513253, 0.22854355389337955, 0.22795237072720714, 0.22687944888888922, 0.2288208458895922, 0.22722295756505922, 0.22846054530126025, 0.22683209623643655, 0.2281264839273529], 'diff_mean': [20.063996245075835, 20.145307915657384, 20.106844144412605, 20.146684667591245, 20.140304194749525, 20.16346688889477, 20.160378752761968, 20.11742410409383, 20.14998966812189, 20.163808341170984], 'overlap_min': [-2.294425517940808, -2.3393087460885176, -2.175786062410659, -2.371852680336932, -2.311944114151057, -2.4811402961604143, -2.3193508590361733, -2.260500406251873, -2.4672817411522825, -2.0770770365968807]},
    'fdami_linear_dp_3': {'precision': [0.9247787610619469, 0.9137404580152672, 0.934887459807074, 0.9235521235521236, 0.9369582348305753, 0.9487603305785124, 0.9275244299674267, 0.9284082254379284, 0.9590536851683349, 0.9090909090909091], 'recall': [0.8348868175765646, 0.7969374167776299, 0.774300932090546, 0.796271637816245, 0.7916111850865513, 0.7643142476697736, 0.7583222370173103, 0.8115845539280959, 0.7017310252996005, 0.8255659121171771], 'auroc': [0.8150337702340655, 0.7850148931277708, 0.8058251648404536, 0.7987382285466768, 0.8154843074027134, 0.8199081278509511, 0.7898036887897797, 0.8114147669238873, 0.805684789758234, 0.788284964090717], 'dp': [0.2922045324153758, 0.27690910638780897, 0.3560860166964819, 0.29600689411328673, 0.334902699309479, 0.33106818944853944, 0.2788004967492147, 0.30342519173274407, 0.39272775341321586, 0.26004921702214767], 'ftu': [0.11149999999999993, 0.04600000000000004, 0.006000000000000005, 0.06500000000000006, 0.08449999999999991, 0.03949999999999998, 0.0665, 0.11599999999999999, 0.03749999999999998, 0.02849999999999997], 'etasq': [0.1848547247224829, 0.18833058848805032, 0.18894397143186767, 0.18715037255765307, 0.18881690627340533, 0.18638526565604813, 0.18717833288537547, 0.18795274754916227, 0.18588099649801618, 0.18563759171659366], 'wasserstein': [0.2938080217307268, 0.29336171330794075, 0.29435440785737327, 0.29337295080720205, 0.29428740227195666, 0.2951593051231477, 0.29425405241614344, 0.2945594574913095, 0.2940963456746194, 0.2936822514750736], 'diff_mean': [20.057671357912675, 20.13938887424044, 20.098211846766407, 20.140652894254128, 20.131523612464424, 20.15875857882875, 20.153322673035998, 20.109891502672884, 20.145819645494193, 20.15556738039563], 'overlap_min': [-2.6960415317459185, -2.7453084169192983, -2.6313340685920448, -2.7720078987000796, -2.8106005824741027, -2.820405589570857, -2.7942492128334964, -2.8127523114079214, -2.82396077724149, -2.631576577426122]},
    'fdami_linear_dp_4': {'precision': [0.905777166437414, 0.888268156424581, 0.89275956284153, 0.9247889485801996, 0.8973666441593517, 0.9255639097744361, 0.8966015907447578, 0.9205642167780252, 0.8890420399724328, 0.9021339220014717], 'recall': [0.8768308921438083, 0.8468708388814914, 0.87017310252996, 0.8022636484687083, 0.8848202396804261, 0.8195739014647138, 0.8255659121171771, 0.8255659121171771, 0.8588548601864181, 0.8162450066577897], 'auroc': [0.8008652452686913, 0.7627928491596212, 0.7774560291766267, 0.8027382499371655, 0.7897996780731448, 0.810389360370911, 0.7692086588698335, 0.8053532371830865, 0.7677808437478275, 0.7745883667827101], 'dp': [0.2184093516924842, 0.2588495700786061, 0.27306946929039944, 0.25596100915084397, 0.25937120004916614, 0.3190425331553661, 0.16643838118197096, 0.26007409333160014, 0.18229280601376396, 0.24381783471802565], 'ftu': [0.06599999999999995, 0.05349999999999999, 0.16549999999999998, 0.10199999999999998, 0.0595, 0.15400000000000003, 0.11699999999999999, 0.04149999999999998, 0.09599999999999997, 0.062000000000000055], 'etasq': [0.18508317354476395, 0.18615074244589302, 0.18764215966016193, 0.18642700242540314, 0.18888555602506923, 0.18774118707407356, 0.18803719834956278, 0.1882948961285501, 0.18688090195928433, 0.18719807158394147], 'wasserstein': [0.3387622479291895, 0.3392368047760088, 0.33938040710004447, 0.3386630161996517, 0.3379728732338814, 0.33929477099612093, 0.3376894834680925, 0.3386961203630464, 0.3410854261273566, 0.33885609820576484], 'diff_mean': [20.05416955083359, 20.13642234251848, 20.094071867419444, 20.137838948565918, 20.128702491282475, 20.154732723688983, 20.15012493929237, 20.10583347997888, 20.141835448759938, 20.152589499906195], 'overlap_min': [-2.8547926590369452, -2.831352936845044, -2.855154704047235, -2.9242044503453766, -2.9776422079616287, -2.939351354576077, -2.9563984909919467, -2.9746245436580123, -2.973741160281193, -2.8304215708080607]},
    'fdami_linear_dp_5': {'precision': [0.8438050499119202, 0.8484299516908212, 0.8691529709228825, 0.8763368983957219, 0.8647490820073439, 0.8823151125401929, 0.8758169934640523, 0.8464755077658304, 0.8574953732264035, 0.8539603960396039], 'recall': [0.9567243675099867, 0.9354194407456724, 0.9154460719041279, 0.8728362183754993, 0.940745672436751, 0.9134487350199734, 0.8921438082556591, 0.9434087882822902, 0.9254327563249002, 0.918774966711052], 'auroc': [0.7112939106626239, 0.7157016882443221, 0.7498917106508589, 0.7506751373001996, 0.7484852860175724, 0.7729894277509506, 0.7553088519189942, 0.713672265627089, 0.7307886673190767, 0.7224396921908673], 'dp': [0.14744693057946068, 0.1218195749028066, 0.2129360465116279, 0.14451262007000987, 0.16783655766706618, 0.25204161251416934, 0.2015304258894003, 0.112263467716477, 0.15043885456793615, 0.1356004610202074], 'ftu': [0.07750000000000001, 0.07050000000000001, 0.056499999999999995, 0.04500000000000004, 0.08449999999999991, 0.15600000000000003, 0.06400000000000006, 0.013000000000000012, 0.0655, 0.04300000000000004], 'etasq': [0.18949958576969084, 0.18839402976870429, 0.18598778013836845, 0.1873831156520074, 0.18695480596544978, 0.18792626794363607, 0.18736990993089822, 0.18724911276865194, 0.18430664705900363, 0.18736339841230482], 'wasserstein': [0.36704195386458943, 0.3676524614724951, 0.368109251438682, 0.3687021284332033, 0.36633367409285084, 0.3671531265812723, 0.36676645932084784, 0.36603684860933194, 0.3666131264364818, 0.3671276923134459], 'diff_mean': [20.04985313753649, 20.132022991486817, 20.090472130020654, 20.13418450488765, 20.125351935414916, 20.149748238365586, 20.146180677676252, 20.10146505417066, 20.138938045524306, 20.148519006495142], 'overlap_min': [-2.945751287851613, -2.9068852110951044, -2.9380674754054388, -2.98974662998134, -2.986179145781603, -3.079164373678878, -3.005419957003297, -3.0507562527503813, -3.0027865810580785, -2.9320580082141983]},
    'fdami_linear_dp_6': {'precision': [0.7980508933405522, 0.8022875816993464, 0.8068057080131723, 0.7898936170212766, 0.7827459231983167, 0.7909090909090909, 0.7948580610605249, 0.7856008470089995, 0.7959073774905762, 0.8087431693989071], 'recall': [0.9813581890812251, 0.9806924101198402, 0.9786950732356857, 0.988681757656458, 0.9906790945406125, 0.9846870838881492, 0.9880159786950732, 0.9880159786950732, 0.9840213049267643, 0.9853528628495339], 'auroc': [0.6161811025727411, 0.6258883737346189, 0.635933881999369, 0.5977545334467029, 0.5806809127321537, 0.5997732608195766, 0.6094698367370948, 0.5873814833234402, 0.6114885641099685, 0.6412708089348071], 'dp': [0.07711201950659785, 0.05609693805159055, 0.08044499105545622, 0.05270631463941766, 0.03237283745758324, 0.054361113613206724, 0.04814997443202562, 0.027515737869306056, 0.06143496026737194, 0.06890828100872648], 'ftu': [0.03300000000000003, 0.026499999999999968, 0.007000000000000006, 0.030000000000000027, 0.0050000000000000044, 0.007500000000000062, 0.03649999999999998, 0.0050000000000000044, 0.04400000000000004, 0.01650000000000007], 'etasq': [0.18690537067366345, 0.18604607515768343, 0.18821089081842396, 0.1858509526405985, 0.18582747894072543, 0.18709038610206213, 0.18804954759859263, 0.1869688955129479, 0.1854362885966561, 0.18897482065162655], 'wasserstein': [0.3842546461071302, 0.38378234046964077, 0.38720870427896714, 0.38602700079083696, 0.38596944767394364, 0.3844450878488196, 0.3851884928253324, 0.3855113971143809, 0.3840822777476496, 0.38391656070724134], 'diff_mean': [20.044362828838846, 20.127487689340047, 20.085177012915256, 20.1293172511245, 20.120696254552424, 20.144598479145948, 20.14152850632861, 20.097016954282967, 20.133809206948392, 20.143550726040726], 'overlap_min': [-2.9444982719510984, -2.9247593862734957, -2.9359266750303235, -3.0134519975148617, -3.0032109001562453, -3.0629363135650096, -3.019503818326968, -2.9956941605744385, -3.0156130751591483, -2.9267196335459467]},
    'fdami_linear_dp_7': {'precision': [0.7602635580334516, 0.759249873289407, 0.7535140562248996, 0.7661207778915046, 0.7583417593528817, 0.7627032520325203, 0.7690329218106996, 0.7579746835443038, 0.7656967840735069, 0.7626082526744778], 'recall': [0.9986684420772304, 0.9973368841544608, 0.9993342210386151, 0.9966711051930759, 0.9986684420772304, 0.9993342210386151, 0.9953395472703063, 0.9966711051930759, 0.9986684420772304, 0.9966711051930759], 'auroc': [0.5244346226450408, 0.5217608115551421, 0.5066952229691067, 0.539500211231076, 0.5194145423237557, 0.5307916085112754, 0.5468665607837475, 0.5184158738816785, 0.5384908475446393, 0.5304640666527628], 'dp': [0.0068846815834767705, 0.00418286557507308, 0.005832587954681001, 0.025054826618280512, 0.0015847303982897687, 0.013813127384220802, 0.007177295638834069, 0.011954281257544053, 0.017990522191898117, 0.014722831625274213], 'ftu': [0.0050000000000000044, 0.006000000000000005, 0.0034999999999999476, 0.01550000000000007, 0.0035000000000000586, 0.009000000000000008, 0.0040000000000000036, 0.01750000000000007, 0.02100000000000002, 0.01100000000000001], 'etasq': [0.1896631928280265, 0.18648468746268645, 0.1852277233608454, 0.18750724483967454, 0.1870312508513024, 0.18847598436405627, 0.1889412776334393, 0.18712154376722245, 0.18933907979239528, 0.1860100345802739], 'wasserstein': [0.3935446850957181, 0.3928908026912447, 0.39369461546226103, 0.39538170583248833, 0.3952138707590188, 0.39500098998445465, 0.39498523218519166, 0.39473732400418693, 0.3964194323926029, 0.393609966063901], 'diff_mean': [20.03671842832885, 20.119569729405697, 20.077353012548855, 20.12198546074352, 20.113329253852594, 20.13760207624386, 20.133858211475097, 20.08941257538328, 20.12568064974581, 20.135832651266373], 'overlap_min': [-2.8983511732063247, -2.871533238092992, -2.90113229184613, -2.960160165066361, -2.958118800033486, -3.020024930314924, -2.968177910865209, -2.986047337806578, -2.9453383122836354, -2.885630157047733]},
    'fdami_linear_dp_8': {'precision': [0.7520040080160321, 0.7523809523809524, 0.7526342197691922, 0.754394776494224, 0.751, 0.7526342197691922, 0.751, 0.7520040080160321, 0.7528879959819186, 0.7522567703109327], 'recall': [0.9993342210386151, 0.9993342210386151, 0.9986684420772304, 1.0, 1.0, 0.9986684420772304, 1.0, 0.9993342210386151, 0.9980026631158455, 0.9986684420772304], 'auroc': [0.5026791587120786, 0.5036831747763357, 0.5043543013599003, 0.5090361445783133, 0.5, 0.5043543013599003, 0.5, 0.5026791587120786, 0.5050254279434649, 0.5033502852956433], 'dp': [0.0007709409064831085, 0.001447260137915407, 0.00042859272510431534, 0.00013983772003123285, 0.0, 0.0027291688844333084, 0.0, 0.0005942322333846173, 0.005181092580006319, 0.0023273510473079684], 'ftu': [0.0004999999999999449, 0.0030000000000000027, 0.0030000000000000027, 0.0035000000000000586, 0.0020000000000000018, 0.0040000000000000036, 0.0004999999999999449, 0.0025000000000000577, 0.0014999999999999458, 0.0015000000000000568], 'etasq': [0.18643463033724017, 0.1857090969989129, 0.1856103480680894, 0.1878216291396512, 0.18657057373783234, 0.18778555513601877, 0.18735146248527154, 0.18712616610920563, 0.18678621155001845, 0.18691370513383357], 'wasserstein': [0.4015160199475314, 0.3990164014404808, 0.39860943937421545, 0.399957274511066, 0.40002231314806136, 0.4009640150039402, 0.40040421483226973, 0.3985775250520445, 0.3997496419507863, 0.3990873745258309], 'diff_mean': [20.027549870364137, 20.108657349669016, 20.067045438627733, 20.111577273185382, 20.10156897181374, 20.126876793079642, 20.123553276017383, 20.078741110749117, 20.114808465636656, 20.12459841068534], 'overlap_min': [-2.810672258089613, -2.7720534656484577, -2.8020424828348025, -2.871733749489975, -2.8576718861512447, -2.9200600371726395, -2.871708470649267, -2.8755016625352567, -2.8689786188398863, -2.7923963005443975]},
    'fdami_linear_dp_9': {'precision': [0.751, 0.7520040080160321, 0.7520040080160321, 0.751, 0.751375687843922, 0.7516274411617426, 0.7520040080160321, 0.7521281922884326, 0.7508754377188595, 0.7518796992481203], 'recall': [1.0, 0.9993342210386151, 0.9993342210386151, 1.0, 1.0, 0.9993342210386151, 0.9993342210386151, 1.0, 0.9993342210386151, 0.9986684420772304], 'auroc': [0.5, 0.5026791587120786, 0.5026791587120786, 0.5, 0.501004016064257, 0.5016751426478216, 0.5026791587120786, 0.5030120481927711, 0.49966711051930757, 0.5023462692313863], 'dp': [0.0, 0.0038366582479638645, 0.001751639833035168, 0.0, 0.0007704160246533309, 0.00016728296205481552, 0.0038899846592154175, 0.00245585040203522, 0.001615508885298822, 0.00510637729786978], 'ftu': [0.0, 0.0010000000000000009, 0.000500000000000056, 0.0, 0.0020000000000000018, 0.0010000000000000009, 0.0004999999999999449, 0.0004999999999999449, 0.0020000000000000018, 0.0020000000000000018], 'etasq': [0.1858299196751181, 0.18785726099378416, 0.187802353974695, 0.18626413664529007, 0.18634631952283157, 0.18776197550108858, 0.18683391669003888, 0.18719416512808265, 0.18753615914860397, 0.18996286711089438], 'wasserstein': [0.40061017582639136, 0.40121237130678855, 0.40170031915996784, 0.39973991906717266, 0.40022973508849624, 0.40241888400806924, 0.4010467017544303, 0.400481058697607, 0.40090506418167426, 0.40103048577409955], 'diff_mean': [20.012349804149554, 20.09589426774112, 20.05366315366539, 20.096243729696422, 20.08746582596277, 20.114139677056297, 20.1103230629516, 20.065099896824137, 20.10041741849699, 20.11056846578064], 'overlap_min': [-2.6918528642056794, -2.6403359744522232, -2.671885456979741, -2.7440064954767087, -2.7262056698842962, -2.7843290475909424, -2.742164634998983, -2.753044406055243, -2.7371769397114636, -2.670606762435067]},
    'fdami_linear_dp_10': {'precision': [0.751, 0.751375687843922, 0.751375687843922, 0.751, 0.7516274411617426, 0.751, 0.751, 0.7517517517517518, 0.751375687843922, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.501004016064257, 0.501004016064257, 0.5, 0.5016751426478216, 0.5, 0.5, 0.5020080321285141, 0.501004016064257, 0.5], 'dp': [0.0, 0.0007434944237918462, 0.0016025641025640969, 0.0, 0.002078586824349471, 0.0, 0.0, 0.0031847133757961776, 0.001615508885298822, 0.0], 'ftu': [0.0004999999999999449, 0.0004999999999999449, 0.000500000000000056, 0.0, 0.0004999999999999449, 0.0, 0.0, 0.0014999999999999458, 0.0004999999999999449, 0.0010000000000000009], 'etasq': [0.1866245333141145, 0.18832790242854766, 0.18761231696233227, 0.18766034179664615, 0.18590785484688468, 0.18567798770077867, 0.1853411953120578, 0.18661952912421576, 0.1871730486014377, 0.18578544099086178], 'wasserstein': [0.4000060633131066, 0.4014566202786177, 0.40023725307701147, 0.40062914760612556, 0.4003196971386024, 0.3997874369469573, 0.4011590611801701, 0.39935786493018355, 0.39778626725619565, 0.39944578240890916], 'diff_mean': [19.993444157091606, 20.07651864776688, 20.034992077318712, 20.07813309960338, 20.07000663808562, 20.093813435780113, 20.09354864116381, 20.0466031064187, 20.083310504578186, 20.092972628166912], 'overlap_min': [-2.516678300842452, -2.4941608106804707, -2.4980900554629146, -2.5796391884867704, -2.524292873952591, -2.6112695909768813, -2.5755859373620145, -2.5844121998745555, -2.5555207734116916, -2.4918652862038133]},
    'fdami_linear_dp_11': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
    'fdami_linear_dp_12': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
}
 """
experiment_results_linear = {
    'original': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [], 'wasserstein': [], 'uf': [], 'tv': []},
    'fdami_linear_dp_1': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18564145770094503, 0.18656490104765863, 0.1857706032985035, 0.18722656706331176, 0.18610838390583181, 0.1904816478391715, 0.1878886287306574, 0.1856176023610295, 0.18644268131870045, 0.18711335566350676], 'wasserstein': [0.0001414213505890226, 0.0001414213504515393, 0.0001414213504150283, 0.00014142135056216385, 0.00014142135065754545, 0.00014142135051572696, 0.00014142135043340406, 0.00014142135052692845, 0.00014142135060931366, 0.00014142135044050108], 'uf': [0.29603936901807465, 0.2978447523487553, 0.294616595182425, 0.2898396747283301, 0.30266809776227627, 0.29897603780311094, 0.2933846054070365, 0.2976392308889447, 0.2986196807583404, 0.29499711029162623], 'tv': [0.19965396024452653, 0.20136046563779575, 0.20071532336792908, 0.1997903872613499, 0.2002487814825935, 0.20068187550770122, 0.19968448394190086, 0.20005598305574657, 0.1997037556632104, 0.1998828764041164]},
    'fdami_linear_dp_2': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18525384852234617, 0.1886684393479689, 0.18583111621841034, 0.18673276098009345, 0.18599588395121605, 0.18673290150693986, 0.1868203982530717, 0.18736420972851553, 0.18569915510778331, 0.18593729191104544], 'wasserstein': [0.1359785774201627, 0.1360739062939111, 0.13599465385087203, 0.13602022613074577, 0.13600004555489215, 0.13602071851977823, 0.13602296096723399, 0.1360368917684079, 0.13599296242996314, 0.13599760042117834], 'uf': [0.29054316742072456, 0.29543105561569716, 0.30169045516298476, 0.2989584040820673, 0.29268481638660027, 0.3000360486775876, 0.2926379232347463, 0.298212984233445, 0.29060427921371235, 0.2906431258880866], 'tv': [0.1994721686987787, 0.20083842176104405, 0.20055681126817215, 0.199470726526347, 0.20009229546566376, 0.20036471724572846, 0.19952596346633944, 0.1998974039247602, 0.1996827142100448, 0.19964616598206886]},
    'fdami_linear_dp_3': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18530758597298339, 0.1885762698119444, 0.18598591941439255, 0.1864935917047522, 0.1861569642259203, 0.18743320314808734, 0.18813842472011072, 0.18784686672389397, 0.18652210055295573, 0.18656482728903304], 'wasserstein': [0.24730443778526084, 0.24789818952919584, 0.24751672726894913, 0.24761398942878757, 0.24762384811761812, 0.2477297679644272, 0.24786567532003947, 0.24783055591764697, 0.2476526447770117, 0.24756706423046862], 'uf': [0.28653138708603737, 0.28990324453019345, 0.28204564533568666, 0.28866299769821785, 0.28549642700634115, 0.28279504250429416, 0.2841523035818454, 0.2810325169426372, 0.2870928418711313, 0.2872567258967307], 'tv': [0.18121832756765777, 0.18249342703871752, 0.18242630421189854, 0.18385706778981947, 0.18070228171055525, 0.18053579855805313, 0.1803904202250437, 0.18372896450872467, 0.1802373679890361, 0.18023005369241218]},
    'fdami_linear_dp_4': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18709957942153968, 0.18660658770897517, 0.18825969239732426, 0.18820747548047612, 0.18909720706720062, 0.185841989495523, 0.1870228947492438, 0.18678562467669435, 0.18688537926693652, 0.1879001321842974], 'wasserstein': [0.33879086737505876, 0.33878300733285843, 0.33915486484578633, 0.3388704897275324, 0.33953274483644635, 0.33868978460181653, 0.3384848191845441, 0.33882101378232415, 0.33887841771398813, 0.33913990330719945], 'uf': [0.2532258638095271, 0.25464951403490627, 0.2614423964499951, 0.24593734122045122, 0.2526281622936416, 0.25264533424195407, 0.2596615457547707, 0.24628725379739475, 0.2469083895638433, 0.2431970630890129], 'tv': [0.13854605861817992, 0.1402328733636493, 0.1445761564767547, 0.13550429387630536, 0.13998555326908546, 0.14110414215000133, 0.13770740246711455, 0.13482005004467523, 0.13392648760390025, 0.13769333353760127]},
    'fdami_linear_dp_5': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18743833027909443, 0.1870654505841185, 0.1873672023800412, 0.18629485609626514, 0.1874865919596118, 0.1876514150399921, 0.18579243559692923, 0.18743702903373508, 0.18679644328151865, 0.18812149633654643], 'wasserstein': [0.4176585598668006, 0.41702712641962253, 0.4170225263289267, 0.4158273728974382, 0.41648924869313775, 0.416800475693527, 0.4165787564440671, 0.41785408508814637, 0.4168518187352875, 0.41696011130659494], 'uf': [0.2219093241107128, 0.21823205287981934, 0.21047051370587613, 0.2192001654618741, 0.23238640157436075, 0.22100601428975652, 0.21276389858141972, 0.21722089183823706, 0.21763940581648406, 0.22133652376910776], 'tv': [0.10011923407972434, 0.10606212860756958, 0.09243059219527161, 0.1007153448580903, 0.10868570037450043, 0.1040832861276777, 0.10080103354754599, 0.10268945634618265, 0.10650010209398963, 0.10214280006800913]},
    'fdami_linear_dp_6': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.1879081750224465, 0.1862513428781448, 0.1860239487359584, 0.18714678320013434, 0.18591198163725253, 0.1859981608308864, 0.18621520831181154, 0.18629668268968486, 0.18782111417419542, 0.1862950355533933], 'wasserstein': [0.48156583768454847, 0.4817853280425294, 0.4815407701309813, 0.481056331880479, 0.48076817130314076, 0.4813117680071874, 0.4807640379406463, 0.4818727005523247, 0.48124160749891914, 0.4810421048346985], 'uf': [0.1843362636680731, 0.19770099578452896, 0.19729100880444445, 0.1871552486866777, 0.18958135643880014, 0.20147287459553403, 0.18030082410057163, 0.20434245300705822, 0.19514208110406586, 0.17872227780604022], 'tv': [0.0712280976129237, 0.07456618845725893, 0.07872397740920012, 0.0785361117468445, 0.07786214729984187, 0.08174395642722265, 0.07424049648478293, 0.08664085069562732, 0.07685315083952171, 0.07582889200898058]},
    'fdami_linear_dp_7': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18588630754323407, 0.1873438033030693, 0.1868803463902248, 0.18794855241831074, 0.1884003106084627, 0.1882597707649782, 0.18584744726221572, 0.18736623540724795, 0.188597530698272, 0.18749248822651837], 'wasserstein': [0.533188126831753, 0.5329475080887787, 0.5338709476593582, 0.5341344793528514, 0.5335590463590458, 0.5334509451093572, 0.5324776612000893, 0.5343990183706683, 0.5342910909091839, 0.5330026057399359], 'uf': [0.16902775287885274, 0.170152943852413, 0.1575349068793909, 0.16678999487003338, 0.18738098319715948, 0.18341930275458151, 0.16043345966703115, 0.1646792748575988, 0.16030684279137264, 0.16489447141405741], 'tv': [0.06181869098985049, 0.06393518228352602, 0.057440518050919764, 0.06124671068778886, 0.06321759669215754, 0.06739055039221653, 0.05405889406429354, 0.05479509257778792, 0.05930056384653226, 0.05896635347594836]},
    'fdami_linear_dp_8': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18718669954876654, 0.1858383962315001, 0.18565481709221598, 0.18498312192131264, 0.18842635306679292, 0.18734202985103574, 0.18673675668912332, 0.18604591835386894, 0.18734273154042405, 0.18582460413807864], 'wasserstein': [0.5748690264708225, 0.5739674585068701, 0.5748929838625367, 0.5727072454027112, 0.5756949278882345, 0.5749237963936052, 0.574928518343438, 0.5738891805682833, 0.5741978277386587, 0.5750144378626662], 'uf': [0.14982716999453805, 0.14986450438921536, 0.14940837153940717, 0.1497873579785689, 0.13904577408345206, 0.1426414426152739, 0.15924874492280464, 0.152150109802488, 0.15157480429777506, 0.15405346448443905], 'tv': [0.050036444926354395, 0.051611960696115844, 0.049218120969561574, 0.045542671296468606, 0.040548395431745377, 0.04539417432067383, 0.04953839630675472, 0.046647123570839444, 0.0478614368778949, 0.04410609072737981]},
    'fdami_linear_dp_9': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18578021566247588, 0.18677480665871718, 0.1877471995013798, 0.1865589923976373, 0.18808594539987067, 0.18444769280371057, 0.18541953260370925, 0.1883713058059061, 0.18773738022249614, 0.18662523253503935], 'wasserstein': [0.6067959355874791, 0.6060027745401555, 0.6073624817189776, 0.6054035856076448, 0.6072570705591389, 0.6069206895337292, 0.6072441111024153, 0.6066112620905113, 0.6078231098128117, 0.6077811886837728], 'uf': [0.09499902682639699, 0.12648366420147508, 0.12515078737552612, 0.12641159200134217, 0.1423081114144372, 0.1396676285337905, 0.1444916172119291, 0.11717386434767788, 0.12420983688479896, 0.15274902784496422], 'tv': [0.03098049629942068, 0.03828535451295245, 0.03355608909759222, 0.040093486307063, 0.039964551050118646, 0.03550857144764252, 0.04073739373988494, 0.035476667287096864, 0.03580502238016192, 0.04206896924626946]},
    'fdami_linear_dp_10': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18613957431513078, 0.18787221706001203, 0.18747491633575294, 0.18736928277989456, 0.18721658732626525, 0.18680156954299776, 0.18674406068480534, 0.1876331138039668, 0.18626981583889446, 0.18576894488044518], 'wasserstein': [0.6306341250002173, 0.6311018154956404, 0.6334034752005206, 0.6344528739649468, 0.6307401644504425, 0.6324941606772254, 0.6328756182352019, 0.6314421637702894, 0.6306018388397443, 0.6313410286734651], 'uf': [0.13714606168697763, 0.12959953239070426, 0.11813106155196501, 0.11362938796937794, 0.11795622759045973, 0.12727774947591522, 0.09147867144336365, 0.11889893634392573, 0.10665444993252263, 0.1298565161502268], 'tv': [0.03551712200902146, 0.03530660635755567, 0.028506007379786147, 0.02109524236284177, 0.035595696438672, 0.031666765367815874, 0.018695816130089082, 0.030615366064265626, 0.0303031493687671, 0.03611876614992904]},
    'fdami_linear_dp_11': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.18710551817495222, 0.18486469890180207, 0.18514808058285898, 0.18559431126813972, 0.1868822742158617, 0.1866009896757391, 0.18725323623176218, 0.1857678743732304, 0.18909793585616957, 0.18667068669199294], 'wasserstein': [0.6533380171193307, 0.6497240486036681, 0.651405487457065, 0.6500009074721586, 0.6498396824618156, 0.6524277939485029, 0.6527823592307717, 0.6515514644496551, 0.6520912072481574, 0.6516434520433223], 'uf': [0.10005156403738721, 0.10534884613696334, 0.10500058193605133, 0.12902690897289948, 0.1228014704970475, 0.10490652213493804, 0.11016146236155186, 0.11688189742335714, 0.1268215581333069, 0.11770844508032338], 'tv': [0.02587147835697512, 0.030781827409887552, 0.024626139622388465, 0.0300877376963945, 0.02996886451725511, 0.025690675041117106, 0.02506292044574754, 0.02262080906643915, 0.02959579690531755, 0.031957709340028506]},
    'fdami_linear_dp_12': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [0.1856722785947398, 0.1859049370829532, 0.1858029704147258, 0.18835446373403958, 0.18706079065484177, 0.18708222250650672, 0.18789129490881654, 0.1880389129676267, 0.1874378626021805, 0.1882791540898838], 'wasserstein': [0.7580483956531048, 0.7567192048461305, 0.7586432718952854, 0.7621474231291502, 0.7592121478361661, 0.7574401048296288, 0.7598604477665156, 0.7615915113775785, 0.758262964757489, 0.760104343929541], 'uf': [0.06339944053578822, 0.028390717011857282, 0.058467798250718774, 0.05674843978190085, 0.04670290063605606, 0.07010385685247836, 0.04392725142319785, 0.0627029555481474, 0.02574485146949468, 0.04922725156176637], 'tv': [0.007560941840623059, 0.0013577646086426753, 0.0010494757899690565, 0.002774006455502187, 0.003201016939100243, 0.002689022801585894, 0.00023599094224269201, 0.004786944031973439, 0.0027505688170388343, 0.0019808351672383484]},
}




experiment_results_decaf = {
    'decaf': {'wasserstein': [0.2973547737359339, 0.2418339163500051, 0.25231253323950703, 0.1944377765966142, 0.2595147751556869, 0.2884869919607355, 0.20574860262881903, 0.3166774652028246, 0.2685093105381815, 0.3061057111501484], 'uf': [0.23530743215822103, 0.16130377550671104, 0.17743247901156084, 0.078001320879174, 0.185844009162567, 0.22333068330573547, 0.09751473078033943, 0.2575779114730099, 0.19821614536642762, 0.2460369634773491]}
}

experiment_results_fairgan = {
    'fairgan': {'wasserstein': [0.4679432021947476, 0.41087281067541526, 0.3712433330713351, 0.3854114995867691, 0.47124884264909683, 0.47956526911499536, 0.43102255853855864, 0.33732882705799466, 0.41977287005674574, 0.4292879740518283], 'uf': [0.4478761413636727, 0.5448665712418499, 0.5042649630094785, 0.4807268004805594, 0.2527485637032103, 0.4533406381136227, 0.40481291505602307, 0.48569409864512736, 0.32452457999243367, 0.53534860693735]}
}

experiment_results_oppdp = {
    'oppdp': {'wasserstein': [0.16270109670863941, 0.15811129613010252, 0.15623762671469296, 0.15199124417871107, 0.15759306695453032, 0.15004116883206203, 0.15465889682143105, 0.15644692034732452, 0.15893694819905912, 0.15338421384773565], 'uf': [0.07072880219893699, 0.10390182992227176, 0.0738168178741817, 0.092646438304683, 0.10912278180060389, 0.12092584295717647, 0.0531252631949937, 0.08305570239895751, 0.08204455257122684, 0.10695447569108688]}
}

experiment_results_tabfairgan = {
    'tabfairgan': {'wasserstein': [0.06306963851038906, 0.0776868801954515, 0.01171173785189111, 0.050203618042152336, 0.04362524095888684, 0.08092971869264254, 0.07910843292727072, 0.09789990115092252, 0.0336394058950096, 0.0670234833099487], 'uf': [0.3490091824108498, 0.3446839245653014, 0.35013225041571355, 0.3520242441381593, 0.3324580849590321, 0.3492830634421829, 0.3326354251044131, 0.33699835717558313, 0.35257306412350053, 0.33596986943790524]}
}


def display_results(results):
    return np.array([np.round(np.mean(results), 3),  np.round(np.std(results), 3)])

df_linear = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
df_linear['model'] = ['fdami_linear_dp_1', 'fdami_linear_dp_2', 'fdami_linear_dp_3', 'fdami_linear_dp_4','fdami_linear_dp_5','fdami_linear_dp_6','fdami_linear_dp_7','fdami_linear_dp_8','fdami_linear_dp_9','fdami_linear_dp_10', 'fdami_linear_dp_11', 'fdami_linear_dp_12']



for model, model_results in experiment_results_linear.items():
    df_linear.loc[df_linear['model'] == model, 'mean'] = display_results(model_results[p_metric])[0]
    df_linear.loc[df_linear['model'] == model, 'std'] = display_results(model_results[p_metric])[1]

df_linear = df_linear.transpose()
df_linear.iloc[0,0] = 0
df_linear.iloc[1,0] = 0

eta_list = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
eta_list['model'] = ['fdami_linear_dp_1', 'fdami_linear_dp_2', 'fdami_linear_dp_3', 'fdami_linear_dp_4','fdami_linear_dp_5','fdami_linear_dp_6','fdami_linear_dp_7','fdami_linear_dp_8','fdami_linear_dp_9','fdami_linear_dp_10', 'fdami_linear_dp_11', 'fdami_linear_dp_12']


for model, model_results in experiment_results_linear.items():
    eta_list.loc[eta_list['model'] == model, 'mean'] = display_results(model_results["etasq"])[0]
    eta_list.loc[eta_list['model'] == model, 'std'] = display_results(model_results["etasq"])[1]

eta_list = eta_list.transpose()
eta_list.iloc[0,0] = 1
print(eta_list)

df_fairgan = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
for ind in range(12):
    df_fairgan.loc[ind, 'mean'] = np.round(np.mean(experiment_results_fairgan['fairgan'][p_metric]), 3)
    df_fairgan.loc[ind, 'std'] = np.round(np.std(experiment_results_fairgan['fairgan'][p_metric]), 3)

df_fairgan = df_fairgan.transpose()

df_decaf = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
for ind in range(12):
    df_decaf.loc[ind, 'mean'] = np.round(np.mean(experiment_results_decaf['decaf'][p_metric]), 3)
    df_decaf.loc[ind, 'std'] = np.round(np.std(experiment_results_decaf['decaf'][p_metric]), 3)

df_decaf = df_decaf.transpose()

df_oppdp = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
for ind in range(12):
    df_oppdp.loc[ind, 'mean'] = np.round(np.mean(experiment_results_oppdp['oppdp'][p_metric]), 3)
    df_oppdp.loc[ind, 'std'] = np.round(np.std(experiment_results_oppdp['oppdp'][p_metric]), 3)

df_oppdp = df_oppdp.transpose()

df_tabfairgan = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
for ind in range(12):
    df_tabfairgan.loc[ind, 'mean'] = np.round(np.mean(experiment_results_tabfairgan['tabfairgan'][p_metric]), 3)
    df_tabfairgan.loc[ind, 'std'] = np.round(np.std(experiment_results_tabfairgan['tabfairgan'][p_metric]), 3)

df_tabfairgan = df_tabfairgan.transpose()

fig, ax = plt.subplots(figsize=(7, 5))

# ax.errorbar(1 / (sig_list ** 2 + 1), df.iloc[0,], yerr=df.iloc[1,], label = "FDA-DECAF")

sig_list = np.arange(0.1, 1.1, 0.1)
sig_list = np.append(0.0001, sig_list)
sig_list = np.append(sig_list, 100000000)
x_list = eta_list.iloc[0,] / (sig_list ** 2 + eta_list.iloc[0,])
ax.plot(x_list, df_fairgan.iloc[0,], label = 'FairGAN', marker = ".")
ax.fill_between(x_list.astype(float), df_fairgan.iloc[0,].astype(float) - df_fairgan.iloc[1,].astype(float), df_fairgan.iloc[0,].astype(float) + df_fairgan.iloc[1,].astype(float), alpha=.1)
ax.plot(x_list, df_linear.iloc[0,], label = "FDA", marker = "^")
ax.fill_between(x_list.astype(float), df_linear.iloc[0,].astype(float) - df_linear.iloc[1,].astype(float), df_linear.iloc[0,].astype(float) + df_linear.iloc[1,].astype(float), alpha=.1)
ax.plot(x_list, df_tabfairgan.iloc[0,], label = 'TabFairGAN', marker = "s")
ax.fill_between(x_list.astype(float), df_tabfairgan.iloc[0,].astype(float) - df_tabfairgan.iloc[1,].astype(float), df_tabfairgan.iloc[0,].astype(float) + df_tabfairgan.iloc[1,].astype(float), alpha=.1)
ax.plot(x_list, df_oppdp.iloc[0,], label = 'OPPDP', marker = "p")
ax.fill_between(x_list.astype(float), df_oppdp.iloc[0,].astype(float) - df_oppdp.iloc[1,].astype(float), df_oppdp.iloc[0,].astype(float) + df_oppdp.iloc[1,].astype(float), alpha=.1)
ax.plot(x_list, df_decaf.iloc[0,], label = 'DECAF', marker = "x")
ax.fill_between(x_list.astype(float), df_decaf.iloc[0,].astype(float) - df_decaf.iloc[1,].astype(float), df_decaf.iloc[0,].astype(float) + df_decaf.iloc[1,].astype(float), alpha=.1)


# ax.errorbar(eta_list.iloc[0,] / (sig_list ** 2 + eta_list.iloc[0,]), df_linear.iloc[0,], yerr=df_linear.iloc[1,], label = "FDA")
# ax.errorbar(eta_list.iloc[0,] / (sig_list ** 2 + eta_list.iloc[0,]), df_fairgan.iloc[0,], yerr=df_fairgan.iloc[1,], label = "fairgan")

ax.set(ylim = (0, 1))
ax.set_xlabel(r"$\alpha$", fontsize = "18")
# ax.set_ylabel(p_metric, fontsize = "15")
if p_metric == 'wasserstein':
    ax.set_ylabel(r"$\hat{W}_2(\mu_\hat{Y}, \mu_{Y})$", fontsize = "18")
# if p_metric == 'uf':
    # ax.set_ylabel(r"$\mathcal{UF(P_{D}, P_{D})}$", fontsize = "15")
ax.set_title("")
ax.legend(bbox_to_anchor=(0.3, 0.7),
              loc='lower left', fontsize= '15', ncol = 2)
# ax.legend(loc = 'upper right', fontsize = "8", ncols = 5)

# plt.show()
plt.xticks(fontsize = '18')
plt.xticks(np.arange(0, 1.2,0.2))
plt.yticks(fontsize = '18')
model = 'combine'
data ='adult'
plt.savefig(f'{model}_{p_metric}_{data}_nips')