import matplotlib.pyplot as plt
import numpy as np
import pandas as pd


experiment_results = {
    'original': {'precision': [0.8869123252858958, 0.8809523809523809, 0.8825357364822871, 0.8690330477356181, 0.8723797780517879, 0.8839848675914249, 0.874384236453202, 0.874845869297164, 0.9029315960912052, 0.8658385093167702], 'recall': [0.929427430093209, 0.9114513981358189, 0.9454061251664447, 0.9454061251664447, 0.9420772303595206, 0.933422103861518, 0.9454061251664447, 0.9447403462050599, 0.9227696404793608, 0.9280958721704394], 'auroc': [0.7859988556088535, 0.7699827271803594, 0.7829440264386439, 0.7578436248322183, 0.7632072898785555, 0.781972096107466, 0.7678837854747886, 0.7685549120583532, 0.8117864266653833, 0.7471804662057016], 'dp': [0.20713777407790324, 0.1964449920501543, 0.17021578299119544, 0.1568267607003777, 0.1578392684781904, 0.15451932640993815, 0.17715036646661164, 0.1319728018144568, 0.1924915229781401, 0.17172428431369247], 'ftu': [0.04700000000000004, 0.03799999999999992, 0.040000000000000036, 0.008499999999999952, 0.020000000000000018, 0.017000000000000015, 0.025500000000000078, 0.020000000000000018, 0.03500000000000003, 0.02650000000000008], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
    'decaf_dp': {'precision': [0.7582529202640934, 0.751386787695411, 0.7511568123393316, 0.7491002570694087, 0.7512716174974567, 0.7573753814852492, 0.7541928721174004, 0.7487179487179487, 0.7494969818913481, 0.7508771929824561], 'recall': [0.9940079893475366, 0.9920106524633822, 0.9727030625832224, 0.9700399467376831, 0.9833555259653795, 0.9913448735019973, 0.9580559254327563, 0.9720372836218375, 0.9920106524633822, 0.9973368841544608], 'auroc': [0.5190923480874229, 0.5010254065529762, 0.5004077561912096, 0.49506013401141186, 0.500713907561003, 0.5167567741003962, 0.5081444285798319, 0.49405077032497496, 0.4960053262316911, 0.4996724581414874], 'dp': [0.0077137947, 0.0013431311, 0.006955266, 0.006955266, 0.0043179393, 0.003155589, 0.014785111, 0.003383398, 3.6120415e-05, 0.0007355809], 'ftu': [0.004999995, 0.0034999847, 0.0010000467, 0.0024999976, 0.0029999614, 0.018000007, 0.040499985, 0.010999978, 0.0020000339, 0.0009999871], 'wasserstein': [], 'diff_mean': [], 'overlap_min': []},
    'fdami_decaf_dp_1': {'precision': [0.8451761987290584, 0.8444313494401886, 0.8679245283018868, 0.8402537485582469, 0.8721945137157108, 0.8535862477771191, 0.8713667285095856, 0.8421361502347418, 0.8604513064133017, 0.8297994269340975], 'recall': [0.974034620505992, 0.9540612516644474, 0.9494007989347537, 0.9700399467376831, 0.9314247669773635, 0.9587217043941412, 0.9380825565912118, 0.9553928095872171, 0.9647137150466045, 0.9640479360852197], 'auroc': [0.7179410050321124, 0.7119703848683683, 0.7568289135236018, 0.7069075235696448, 0.7598890903159911, 0.7313688843255847, 0.7602059369301442, 0.7076160835084679, 0.7464130824229006, 0.6838311969582724], 'dp': [0.10887701348514744, 0.15557010133222204, 0.16906965924498807, 0.1243649736145438, 0.17574986556251715, 0.13683405494085288, 0.18464001372838568, 0.1214678059912544, 0.12830964576870352, 0.10174194975736683], 'ftu': [0.038000000000000034, 0.08950000000000002, 0.06900000000000006, 0.04749999999999999, 0.08899999999999997, 0.07299999999999995, 0.05700000000000005, 0.026499999999999968, 0.03599999999999992, 0.040000000000000036], 'wasserstein': [0.3696042795418694, 0.3695315821960084, 0.36952746725190305, 0.36952746725190305, 0.3695418695562717, 0.36959947877374655, 0.3694787737466565, 0.3696879500720114, 0.36951923736369235, 0.36968177765585336], 'diff_mean': [10.536970803184087, 10.552690789669013, 10.63612886551477, 10.553529380031996, 10.561410584264856, 10.404920106846713, 10.532056605432611, 10.59516292101415, 10.590711790636252, 10.565548119116823], 'overlap_min': [-2.672625932945066, -2.692412994625679, -2.571808807165615, -2.5916266702977415, -2.475602922250585, -2.522962965582591, -2.5793473518264856, -2.78037917037162, -2.6744578525841423, -2.6774764637999295]},
    'fdami_decaf_dp_2': {'precision': [0.812054794520548, 0.8055248618784531, 0.793836344314559, 0.7926634768740032, 0.8067501360914534, 0.8010810810810811, 0.7947761194029851, 0.8006518196632265, 0.8103542234332425, 0.793048128342246], 'recall': [0.9866844207723036, 0.9707057256990679, 0.9946737683089214, 0.992676431424767, 0.9866844207723036, 0.9866844207723036, 0.992676431424767, 0.9813581890812251, 0.9900133155792277, 0.9873501997336884], 'auroc': [0.6489647003459911, 0.63193920823106, 0.6077786512227338, 0.6047719506521425, 0.6369165075749068, 0.6238642987395655, 0.6097920309734277, 0.6222051989582833, 0.645609067428168, 0.6051208829993743], 'dp': [0.07826801115333148, 0.10307620527362416, 0.03844553744180024, 0.0626067166601626, 0.08690289009323648, 0.018670963791786788, 0.06558013719353861, 0.04304901553582019, 0.0784124522040256, 0.039272763210057016], 'ftu': [0.028999999999999915, 0.05900000000000005, 0.011500000000000066, 0.040000000000000036, 0.05699999999999994, 0.03400000000000003, 0.01550000000000007, 0.021499999999999964, 0.0024999999999999467, 0.023500000000000076], 'wasserstein': [0.5887818241394814, 0.5884160513301177, 0.5883627094620854, 0.5879816961189981, 0.588553216133629, 0.5886027478682304, 0.5882655510595981, 0.588701811337433, 0.5885817921343606, 0.5888123052069284], 'diff_mean': [10.55171006153675, 10.563738267211608, 10.646746089918025, 10.56348293445502, 10.577838605137401, 10.416372144770754, 10.543508814616757, 10.60955630419223, 10.604068418178805, 10.578793692246329], 'overlap_min': [-2.873238386420267, -2.894667001072558, -2.8289049004970703, -2.8475525902633825, -2.7575850324518134, -2.803847555529578, -2.825794629565704, -2.907268632139381, -2.8686692326938856, -2.885494586311783]},
    'fdami_decaf_dp_3': {'precision': [0.7653061224489796, 0.7582195245321194, 0.7660338635197537, 0.7585858585858586, 0.7618080243778568, 0.7602635580334516, 0.7688751926040062, 0.7657289002557545, 0.766359918200409, 0.7671794871794871], 'recall': [0.9986684420772304, 0.9980026631158455, 0.9940079893475366, 1.0, 0.9986684420772304, 0.9986684420772304, 0.9966711051930759, 0.9966711051930759, 0.9980026631158455, 0.996005326231691], 'auroc': [0.5374868314803822, 0.5190816528430634, 0.5391726693725635, 0.5200803212851406, 0.528450686902069, 0.5244346226450408, 0.5465283236808753, 0.5384961951668191, 0.5401659901924609, 0.5421793699431547], 'dp': [0.018976775827884262, 0.010343859140510725, 0.006406808303186073, 0.007429881953941675, 0.0019975193015844273, 0.0023739597806133883, 0.01928973667691769, 0.013988771648178355, 0.01264338792294939, 0.03082749070963875], 'ftu': [0.01200000000000001, 0.006000000000000005, 0.014499999999999957, 0.0020000000000000018, 0.00649999999999995, 0.0035000000000000586, 0.0030000000000000027, 0.00550000000000006, 0.024500000000000077, 0.013500000000000068], 'wasserstein': [0.7321356839834899, 0.7312350150951267, 0.7317168414584818, 0.7311216441861019, 0.7318207647917545, 0.732608062771093, 0.7317199906503992, 0.7321104904481511, 0.7317609301453248, 0.732412812872217], 'diff_mean': [10.54039503416725, 10.554342207709222, 10.638239496804328, 10.557266974011144, 10.56936904791613, 10.412068028274746, 10.53496473396828, 10.603431375100332, 10.597118314686018, 10.572730113213453], 'overlap_min': [-2.901639742586245, -2.9019805959286256, -2.8431657733626734, -2.858497107356147, -2.7888649904255045, -2.8139185656322048, -2.8536101194806585, -2.928035702242756, -2.9104722415066844, -2.8998437435761177]},
    'fdami_decaf_dp_4': {'precision': [0.7563067608476287, 0.7531422825540472, 0.7535140562248996, 0.7536377320622177, 0.7579585649317837, 0.7525050100200401, 0.7546599496221662, 0.7515060240963856, 0.7517517517517518, 0.7535140562248996], 'recall': [0.9980026631158455, 0.9973368841544608, 0.9993342210386151, 1.0, 0.9986684420772304, 1.0, 0.9973368841544608, 0.9966711051930759, 1.0, 0.9993342210386151], 'auroc': [0.5140615725217782, 0.5056965545270296, 0.5066952229691067, 0.5070281124497992, 0.5184105262594988, 0.5040160642570282, 0.5097126187840577, 0.5013476007893091, 0.5020080321285141, 0.5066952229691067], 'dp': [0.00014769660432079057, 0.000862931975593284, 0.0010969037080267308, 0.002717649250976506, 0.000326288013406284, 0.005961251862891204, 0.00459494488324097, 0.0035281105474638252, 0.003012048192771122, 0.0007277309282275324], 'ftu': [0.006000000000000005, 0.0025000000000000577, 0.000500000000000056, 0.0, 0.0030000000000000027, 0.0050000000000000044, 0.010499999999999954, 0.005499999999999949, 0.0025000000000000577, 0.011500000000000066], 'wasserstein': [0.8321188533022427, 0.8308972292709691, 0.8319002468966463, 0.8304814484603251, 0.8327446677182635, 0.833456210136479, 0.8302371236540703, 0.8329804197242987, 0.8314115972841369, 0.8322560181057541], 'diff_mean': [10.53074815373845, 10.538887412535235, 10.627347324147369, 10.53399729023273, 10.553300662918263, 10.398615634406093, 10.517185633058158, 10.58917612464935, 10.581151791260165, 10.559048809431676], 'overlap_min': [-2.8655590666422888, -2.8657867864017783, -2.819030302969921, -2.8014177932317477, -2.7441860284196835, -2.7746993781721567, -2.7994676524278974, -2.9001050712401883, -2.8515768913840414, -2.883186808622746]},
    'fdami_decaf_dp_5': {'precision': [0.7517517517517518, 0.7520040080160321, 0.7517517517517518, 0.7521281922884326, 0.7517517517517518, 0.751, 0.7523809523809524, 0.7528879959819186, 0.7526342197691922, 0.751], 'recall': [1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 0.9980026631158455, 0.9986684420772304, 1.0], 'auroc': [0.5020080321285141, 0.5026791587120786, 0.5020080321285141, 0.5030120481927711, 0.5020080321285141, 0.5, 0.5036831747763357, 0.5050254279434649, 0.5043543013599003, 0.5], 'dp': [0.0015082956259426794, 0.0007157126096783983, 0.001446131597975464, 0.0025184252869118184, 0.003062787136294043, 0.0, 0.0037369207772794955, 0.00046901469579374577, 0.0037785874035062283, 0.0], 'ftu': [0.000500000000000056, 0.0010000000000000009, 0.0004999999999999449, 0.000500000000000056, 0.0004999999999999449, 0.0, 0.0015000000000000568, 0.0020000000000000018, 0.007500000000000062, 0.0], 'wasserstein': [0.9050622702807053, 0.9026915205903844, 0.9036493458000899, 0.9035540924643182, 0.9049352658330095, 0.9061894347540052, 0.9022470050234492, 0.9056337902953362, 0.9044484154501757, 0.9064857784652952], 'diff_mean': [10.510171447636129, 10.514834275042425, 10.599313297014085, 10.514768984603204, 10.534985965751591, 10.38051167811387, 10.492994789734226, 10.572846413618095, 10.568109835960461, 10.543047115737052], 'overlap_min': [-2.80256294137344, -2.7943221661922824, -2.748029292931232, -2.7249166222602312, -2.6943455974931347, -2.7112690632836993, -2.7179080639559716, -2.847031003211926, -2.7994447430960276, -2.824899151459815]},
    'fdami_decaf_dp_6': {'precision': [0.751, 0.751, 0.751, 0.751375687843922, 0.751, 0.751, 0.751375687843922, 0.7520040080160321, 0.7512512512512513, 0.751503006012024], 'recall': [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 0.9993342210386151, 0.9986684420772304], 'auroc': [0.5, 0.5, 0.5, 0.501004016064257, 0.5, 0.5, 0.501004016064257, 0.5026791587120786, 0.5006711265835646, 0.5013422531671293], 'dp': [0.0, 0.0, 0.0, 0.000723065798987732, 0.0, 0.0, 0.0015105740181269312, 0.00409746172046721, 0.0007575211023735928, 0.0014869070200205226], 'ftu': [0.0, 0.0, 0.0, 0.000500000000000056, 0.0010000000000000009, 0.0004999999999999449, 0.0010000000000000009, 0.0020000000000000018, 0.008000000000000007, 0.0010000000000000009], 'wasserstein': [0.9601275632672656, 0.9579487003634867, 0.9593128043344078, 0.957646251971744, 0.959855976956313, 0.9608250462931212, 0.9573808380769494, 0.9601707701803717, 0.9591091146011933, 0.9607941842123311], 'diff_mean': [10.491537565408029, 10.495294538272018, 10.57766625314332, 10.488549737483769, 10.514235655214513, 10.366174897023221, 10.471558677509176, 10.559993856215051, 10.542636542038217, 10.521879038170743], 'overlap_min': [-2.744323268604032, -2.714478847615358, -2.6579790622722843, -2.655351172096651, -2.6167385058933927, -2.642461598432153, -2.65161147497641, -2.7851057141945947, -2.709241001156375, -2.7610577830250698]},
    'fdami_decaf_dp_7': {'precision': [0.751, 0.7508754377188595, 0.7512512512512513, 0.751375687843922, 0.7508754377188595, 0.751, 0.751, 0.751, 0.751, 0.751], 'recall': [1.0, 0.9993342210386151, 0.9993342210386151, 1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.49966711051930757, 0.5006711265835646, 0.501004016064257, 0.49966711051930757, 0.5, 0.5, 0.5, 0.5, 0.5], 'dp': [0.0, 0.0007451564828614421, 0.001446131597975464, 0.000723065798987732, 0.0015313935681470214, 0.0, 0.0, 0.0, 0.0, 0.0], 'ftu': [0.0, 0.0004999999999999449, 0.0004999999999999449, 0.0010000000000000009, 0.000500000000000056, 0.0, 0.0004999999999999449, 0.0004999999999999449, 0.0, 0.0], 'wasserstein': [1.0025997548037437, 1.0015929821498712, 1.0017526771225544, 1.0009055994413651, 1.0038634280658458, 1.0043563995032594, 0.9999752026439933, 1.0045230377356245, 1.0021484429244216, 1.0034746055236607], 'diff_mean': [10.476570520570576, 10.477584668004635, 10.563635752864673, 10.466524468391569, 10.496796940143847, 10.347302933807274, 10.449665367850901, 10.54835527182226, 10.527030224468445, 10.511282214588139], 'overlap_min': [-2.6739839740318074, -2.66480778220763, -2.626469809091704, -2.5812092248635032, -2.5606556870415336, -2.5863795453492013, -2.563881903108656, -2.7340537686560715, -2.6609500866505535, -2.706344740315246]},
    'fdami_decaf_dp_8': {'precision': [0.751, 0.751375687843922, 0.751, 0.751, 0.7508754377188595, 0.751375687843922, 0.751375687843922, 0.751, 0.751, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.501004016064257, 0.5, 0.5, 0.49966711051930757, 0.501004016064257, 0.501004016064257, 0.5, 0.5, 0.5], 'dp': [0.0, 0.0007451564828614421, 0.0, 0.0, 0.0007423904974016571, 0.0014903129657227732, 0.0007473841554559435, 0.0, 0.0, 0.0], 'ftu': [0.0, 0.000500000000000056, 0.0, 0.0, 0.000500000000000056, 0.0004999999999999449, 0.0004999999999999449, 0.0, 0.0, 0.0], 'wasserstein': [1.0384137652500591, 1.0356704691798309, 1.0348322398250387, 1.034908442493656, 1.03688971187771, 1.0391910324699571, 1.0337349213969473, 1.03977017275145, 1.0364782174671758, 1.040417895434698], 'diff_mean': [10.467014946048621, 10.463909358433082, 10.546763767039629, 10.451035007753017, 10.488413552609805, 10.338113001942116, 10.433794681028052, 10.535944945167554, 10.51310306698078, 10.500731768220662], 'overlap_min': [-2.6434562858751, -2.6222256167349554, -2.572739514951583, -2.535675051300295, -2.5286122467318073, -2.5600528243125567, -2.5301385496979822, -2.6943954432894266, -2.613917340829305, -2.6639182950255345]},
    'fdami_decaf_dp_9': {'precision': [0.751, 0.751, 0.751, 0.751, 0.751, 0.751, 0.751, 0.751375687843922, 0.751375687843922, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.501004016064257, 0.501004016064257, 0.5], 'dp': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0007256894049346707, 0.001506024096385561, 0.0], 'ftu': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.000500000000000056, 0.0004999999999999449, 0.0], 'wasserstein': [1.0677649928637778, 1.0637629662335153, 1.065020276447951, 1.0615770543574377, 1.0656530404120788, 1.0675842031597413, 1.0618893274825916, 1.068521022535203, 1.0656694758397185, 1.0682416202653287], 'diff_mean': [10.456329426208981, 10.454225639703946, 10.536442040667662, 10.439397878855512, 10.474425124738174, 10.328358299331192, 10.422556664286411, 10.530467635208296, 10.503608343464492, 10.490241192323545], 'overlap_min': [-2.614364277335543, -2.5853945474890434, -2.5354667245816094, -2.4766370651902414, -2.4997646508774602, -2.5338857151627106, -2.492505880871133, -2.6738443510768715, -2.5836822785746083, -2.621271820337439]},
    'fdami_decaf_dp_10': {'precision': [0.751, 0.751, 0.751, 0.751, 0.751, 0.751, 0.751, 0.7508754377188595, 0.751, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 1.0, 1.0], 'auroc': [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.49966711051930757, 0.5, 0.5], 'dp': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001607717041800627, 0.0, 0.0], 'ftu': [0.0, 0.0, 0.0, 0.0, 0.0004999999999999449, 0.0, 0.0, 0.0010000000000000009, 0.0004999999999999449, 0.0], 'wasserstein': [1.0911705056482508, 1.0881962688374163, 1.0876276647412275, 1.0860880598038543, 1.0903744599135863, 1.0913454607547703, 1.0860093300059206, 1.0924651734364963, 1.0889748190614288, 1.092045281180849], 'diff_mean': [10.45134341794077, 10.4486409033298, 10.530756698043684, 10.430535157149393, 10.467896651622409, 10.323197085947106, 10.415469374931773, 10.522310943866259, 10.499128713536336, 10.48688804074514], 'overlap_min': [-2.586735016334554, -2.5595374198235215, -2.5129482888260757, -2.4794921875183333, -2.4765848858329873, -2.5075011221936725, -2.4640296088598532, -2.629950176817996, -2.5534092253886715, -2.61250255732932]},
    'fdami_decaf_dp_11': {'precision': [0.751, 0.751375687843922, 0.751, 0.751, 0.751375687843922, 0.751, 0.751375687843922, 0.751, 0.751, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.501004016064257, 0.5, 0.5, 0.501004016064257, 0.5, 0.501004016064257, 0.5, 0.5, 0.5], 'dp': [0.0, 0.0007451564828614421, 0.0, 0.0, 0.0007423904974016571, 0.0, 0.0007473841554559435, 0.0, 0.0, 0.0], 'ftu': [0.0, 0.0, 0.0, 0.0004999999999999449, 0.0, 0.0, 0.000500000000000056, 0.0, 0.0, 0.0], 'wasserstein': [1.1122666483780264, 1.1072599044418536, 1.1090855679765905, 1.1061718827393336, 1.1106069542555381, 1.1143965891685528, 1.1055725487506574, 1.1140830913898605, 1.1090210243162715, 1.1136681678592384], 'diff_mean': [10.446166454301412, 10.442000276178955, 10.52825708772614, 10.428015337266146, 10.469882827479658, 10.325169502159847, 10.415712783064794, 10.524659873963905, 10.497732480850605, 10.487403801747332], 'overlap_min': [-2.5878384199058644, -2.552343813791298, -2.500606977332425, -2.436621098185374, -2.459075457492683, -2.489642219939335, -2.462284322573662, -2.630722896756563, -2.5491745180055077, -2.6084957020765867]},
    'fdami_decaf_dp_12': {'precision': [0.751, 0.751, 0.751, 0.751, 0.751, 0.7508754377188595, 0.751, 0.751, 0.751, 0.751], 'recall': [1.0, 1.0, 1.0, 1.0, 1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5, 0.5, 0.5, 0.5, 0.5, 0.49966711051930757, 0.5, 0.5, 0.5, 0.5], 'dp': [0.0, 0.0, 0.0, 0.0, 0.0, 0.0014903129657227732, 0.0, 0.0, 0.0, 0.0], 'ftu': [0.0, 0.0, 0.0004999999999999449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0004999999999999449, 0.0], 'wasserstein': [1.1282565924833687, 1.1256815376174474, 1.1268677988478157, 1.1247460307934984, 1.1295875197174405, 1.1316514213702764, 1.1223638639325149, 1.13111133495645, 1.1270413980522598, 1.131130623756944], 'diff_mean': [10.448491665206404, 10.4467420176222, 10.528561295949618, 10.430434681879172, 10.469445249966299, 10.324465278095863, 10.413142140783101, 10.5226681460375, 10.49484735366865, 10.485500210040147], 'overlap_min': [-2.5819539962428992, -2.5364604634484547, -2.502475671822566, -2.4472010437040645, -2.4668869437946483, -2.4935050485887444, -2.4500060509613197, -2.6232258857177957, -2.539844345958043, -2.5991824956205978]},
}


experiment_results_linear = {
'decaf_dp': {'precision': [], 'recall': [], 'auroc': [], 'dp': [], 'ftu': [], 'etasq': [], 'wasserstein': [], 'uf': [], 'tv': []},
'fdami_linear_dp_1': {'precision': [0.8780336029869322, 0.8826886493341788, 0.8817546090273363, 0.8773824650571792, 0.8808933002481389, 0.8664652567975831, 0.8735275883446993, 0.8942931258106356, 0.8879694462126034, 0.8728287841191067], 'recall': [0.9394141145139814, 0.9267643142476698, 0.9234354194407457, 0.9194407456724367, 0.9454061251664447, 0.9547270306258322, 0.9380825565912118, 0.9181091877496671, 0.9287616511318242, 0.936750998668442], 'auroc': [0.7729199086626133, 0.7776391852362847, 0.7749707217685655, 0.765945272434612, 0.7799319782458729, 0.7554759651121129, 0.7642220011871722, 0.795399975400938, 0.7876739982566752, 0.7625522061615302], 'dp': [0.1841306583197061, 0.18263207106124357, 0.1802779628395884, 0.17846051375514804, 0.16277353471209133, 0.13096855503316118, 0.16074659002655434, 0.23019611728093514, 0.16862077388393182, 0.1686746987951807], 'ftu': [0.03399999999999992, 0.03049999999999997, 0.03749999999999998, 0.04500000000000004, 0.03649999999999998, 0.04700000000000004, 0.03400000000000003, 0.04899999999999993, 0.07099999999999995, 0.03149999999999997], 'etasq': [0.1880446572309232, 0.1862564880552435, 0.18704541154025658, 0.18832809212931353, 0.18736601475133752, 0.1862598066567006, 0.18595603550717832, 0.18685893068375545, 0.18640576883491747, 0.18784689462755988], 'wasserstein': [0.00014142135067483016, 0.00014142135058089453, 0.00014142135048111, 0.00014142135076358398, 0.0001414213504508128, 0.000141421350605805, 0.00014142135043769395, 0.00014142135061320256, 0.00014142135058673347, 0.0001414213503528298], 'uf': [0.29123668498601074, 0.289547680090113, 0.2937564672096352, 0.2954673697657893, 0.2884045135432388, 0.2891341741113903, 0.2947244923507076, 0.2983228909806602, 0.2927917471720586, 0.2915351969940072], 'tv': [0.19965346097793124, 0.2003411139126049, 0.2007990770937348, 0.20040526749952325, 0.20038289708469992, 0.20057619723145048, 0.20088282263379686, 0.1994383663855711, 0.2004699513377204, 0.2007436718374218]},
'fdami_linear_dp_2': {'precision': [0.8799249530956847, 0.897078353253652, 0.8663396689147762, 0.8855109961190168, 0.8898847631241997, 0.8717165546731827, 0.8683404776484996, 0.872996300863132, 0.8982154659616656, 0.8857689853222719], 'recall': [0.936750998668442, 0.8994673768308922, 0.940745672436751, 0.9114513981358189, 0.9254327563249002, 0.9500665778961385, 0.9440745672436751, 0.9427430093209055, 0.9047936085219707, 0.9241011984021305], 'auroc': [0.7756044149968716, 0.7941111984556068, 0.7514973342103434, 0.7780148556944155, 0.7900256151102413, 0.7641899154540933, 0.7561738298065765, 0.7645441954235049, 0.797778330365403, 0.7823317236990572], 'dp': [0.19688665014789886, 0.21771856007480128, 0.14944666518617222, 0.20831000035355873, 0.19280871878486228, 0.14456372119630312, 0.15316628765154794, 0.18000248235308858, 0.19789885579359268, 0.18883017098333454], 'ftu': [0.05900000000000005, 0.026000000000000023, 0.02100000000000002, 0.07050000000000001, 0.05349999999999999, 0.04249999999999998, 0.014499999999999957, 0.008000000000000007, 0.025499999999999967, 0.033499999999999974], 'etasq': [0.1881070667542813, 0.1874538613589278, 0.18581210740273835, 0.18722567527510958, 0.1873498127588088, 0.18568121272519966, 0.18740860254603886, 0.18835550363627673, 0.18793761596270925, 0.1863114294967259], 'wasserstein': [0.13605744353794436, 0.13603998792519156, 0.13599494802190287, 0.13603358811978924, 0.13603763081461134, 0.13599114682725724, 0.13603842844585634, 0.13606497534868497, 0.13605332521816335, 0.13600795796880302], 'uf': [0.2966683714748462, 0.2981803924479601, 0.3015856624735909, 0.2939933022967163, 0.2925226459558266, 0.30110055774132394, 0.29773189437810005, 0.2901119753983631, 0.3010560586225623, 0.2986141005264815], 'tv': [0.19936578057021848, 0.2002101459874679, 0.2006426641210931, 0.200428524148497, 0.19988601121957628, 0.20038978010103403, 0.2008533840582415, 0.19933261901603694, 0.20034100539206334, 0.20066321699134204]},
'fdami_linear_dp_3': {'precision': [0.8696711327649208, 0.8765743073047859, 0.8687116564417178, 0.8730456535334584, 0.8743068391866913, 0.8801756587202008, 0.8681114551083592, 0.8691646191646192, 0.900990099009901, 0.8667481662591687], 'recall': [0.9507323568575233, 0.9267643142476698, 0.9427430093209055, 0.929427430093209, 0.9447403462050599, 0.9340878828229028, 0.933422103861518, 0.9420772303595206, 0.9087882822902796, 0.9440745672436751], 'auroc': [0.7605067406777577, 0.7665950085294574, 0.7565120669094487, 0.760898454002428, 0.7675508959940962, 0.7752768731383589, 0.752855630244012, 0.7571831934930133, 0.8037917315065856, 0.7531617816138054], 'dp': [0.17390457467192721, 0.18634876110331933, 0.1594307498704568, 0.15995570250422275, 0.15923224348522547, 0.15469529308711283, 0.16626672433277068, 0.18010951959635568, 0.21563429458166294, 0.1619832623908809], 'ftu': [0.025499999999999967, 0.04300000000000004, 0.052000000000000046, 0.050000000000000044, 0.04999999999999993, 0.07350000000000001, 0.056499999999999995, 0.0645, 0.09799999999999998, 0.09799999999999998], 'etasq': [0.1858744737404608, 0.18792906291289932, 0.18607283827171364, 0.1853332253203814, 0.18911844205825148, 0.1868855689758747, 0.18645770150906574, 0.18666312782493208, 0.18792794506929306, 0.18402160967156705], 'wasserstein': [0.24752553359335316, 0.2478049770934865, 0.24749680454404543, 0.2474654507565281, 0.2479528875500833, 0.24770917805623097, 0.24764769485852003, 0.24759314667367838, 0.2477621953862752, 0.2473024128618036], 'uf': [0.28131142199749304, 0.2886865656632832, 0.29321419866146453, 0.28298416284437844, 0.2883102057548689, 0.28038132640735014, 0.28313666195055937, 0.28304672307844697, 0.28572463413885674, 0.2856605328290388], 'tv': [0.18055203743399073, 0.17918685572316861, 0.1843222399873814, 0.1797147783159142, 0.1783963675702288, 0.18000815415185545, 0.17963853719382894, 0.17798469606069234, 0.18342365738034572, 0.1825295364357865]},
'fdami_linear_dp_4': {'precision': [0.8680048661800487, 0.8594890510948905, 0.856628674265147, 0.8662576687116564, 0.8723532970356926, 0.850324101355333, 0.850887573964497, 0.8691646191646192, 0.887332908975175, 0.8693776956253851], 'recall': [0.9500665778961385, 0.940745672436751, 0.9507323568575233, 0.9400798934753661, 0.9600532623169108, 0.9607190412782957, 0.9573901464713716, 0.9420772303595206, 0.9280958721704394, 0.9394141145139814], 'auroc': [0.7571618030042941, 0.738445125375002, 0.735406339071332, 0.7511644447296509, 0.7681792416002224, 0.7253394403178627, 0.7256830250429147, 0.7571831934930133, 0.7863370927117258, 0.7568556516345009], 'dp': [0.16788443506267015, 0.1527816736792893, 0.14857687467614178, 0.15069588354913732, 0.13022683715209238, 0.12159227015141494, 0.13493403276736848, 0.19377384852408164, 0.17341025235762086, 0.1717138013130366], 'ftu': [0.06899999999999995, 0.06400000000000006, 0.07900000000000007, 0.04400000000000004, 0.044499999999999984, 0.03949999999999998, 0.04600000000000004, 0.09849999999999992, 0.040999999999999925, 0.10299999999999998], 'etasq': [0.18606020568527637, 0.1891053332219728, 0.18641437040077413, 0.18803561400114457, 0.18787092206110997, 0.1874241736961223, 0.18777334036130422, 0.18685027670671084, 0.1875997497135394, 0.18692899617126432], 'wasserstein': [0.33844874648233503, 0.339571314350008, 0.33827213350386476, 0.3387597057007462, 0.3391943000860408, 0.33898717346586554, 0.3388989116129522, 0.3387634981612271, 0.33930852906288617, 0.3391447109119977], 'uf': [0.25554408337040313, 0.24340364284385946, 0.24778576403243946, 0.24582478367443214, 0.24397241393306462, 0.24795758070515575, 0.25251850809952364, 0.24647415013006665, 0.25599146502541836, 0.2438037408511753], 'tv': [0.1385952421441914, 0.13576683848811988, 0.13865344403322644, 0.13828962626748886, 0.13598348428272, 0.13780813601385644, 0.14048217764396442, 0.13843334052523315, 0.1395384162714931, 0.13714240620490625]},
'fdami_linear_dp_5': {'precision': [0.822742474916388, 0.8348519362186788, 0.824354657687991, 0.8191489361702128, 0.8358974358974359, 0.8284258210645526, 0.8308740068104427, 0.8243929983060417, 0.8327683615819209, 0.8183333333333334], 'recall': [0.9826897470039947, 0.9760319573901465, 0.978029294274301, 0.974034620505992, 0.9766977363515313, 0.974034620505992, 0.9747003994673769, 0.9720372836218375, 0.9813581890812251, 0.9806924101198402], 'auroc': [0.6720677650682625, 0.6968513200605351, 0.6747576190247007, 0.6627201214979759, 0.6991922416697416, 0.6828004427831165, 0.6881534125850941, 0.6737696458269831, 0.6934903395205323, 0.6620329520478719], 'dp': [0.0991443157470363, 0.10434782608695647, 0.10383818195277228, 0.09681352282564193, 0.11902514373980955, 0.08065035127549647, 0.09183327055168788, 0.1264849994135725, 0.10371615634773534, 0.09108289445205975], 'ftu': [0.046499999999999986, 0.043500000000000094, 0.06000000000000005, 0.06400000000000006, 0.06399999999999995, 0.062000000000000055, 0.039000000000000035, 0.04249999999999998, 0.04249999999999998, 0.06000000000000005], 'etasq': [0.1888245203665038, 0.18684687185806192, 0.18532234636710057, 0.18834591239400966, 0.18714093921820135, 0.1874342945808657, 0.1851269258868322, 0.18694341150898697, 0.18578011392546417, 0.18762479548800762], 'wasserstein': [0.4181787327051237, 0.4167898034342902, 0.41629080397816737, 0.41757028336693264, 0.41713730735050564, 0.41718282956201846, 0.4161141543726198, 0.41706718937132287, 0.41671670330795757, 0.4162096039578881], 'uf': [0.21860326393552407, 0.2134696980736693, 0.21628906399708403, 0.22113662213859764, 0.2230855633766553, 0.21705509890446742, 0.22179421883323172, 0.2162105454731612, 0.21684248729717237, 0.21029498095736615], 'tv': [0.10600399195580146, 0.10485319646239688, 0.10367559973073925, 0.104619137929442, 0.10452490280742521, 0.10343143490518292, 0.10354931673572909, 0.1074798490466563, 0.1033268279016073, 0.10428225709475714]},
'fdami_linear_dp_6': {'precision': [0.7948854555141183, 0.789920424403183, 0.7908461947844598, 0.7856388595564942, 0.7927736450584485, 0.7877507919746568, 0.8076294277929156, 0.7896678966789668, 0.7982832618025751, 0.7888888888888889], 'recall': [0.9933422103861518, 0.9913448735019973, 0.9893475366178429, 0.9906790945406125, 0.9933422103861518, 0.9933422103861518, 0.9866844207723036, 0.9973368841544608, 0.9906790945406125, 0.992676431424767], 'auroc': [0.61012492045412, 0.5980820753052155, 0.6000954550559094, 0.5877090251819528, 0.6051048401328349, 0.5930566473617506, 0.6389245397034209, 0.5980660324386762, 0.6178295071096638, 0.5957358060738294], 'dp': [0.05315072092191031, 0.04593267882187946, 0.046811385002590855, 0.057931179209830264, 0.06191252610200526, 0.05324549956202296, 0.08520864433500286, 0.04674680795582786, 0.05122826175457751, 0.04851742298535466], 'ftu': [0.03849999999999998, 0.025000000000000022, 0.024499999999999966, 0.015000000000000013, 0.024499999999999966, 0.04150000000000009, 0.05449999999999999, 0.009000000000000008, 0.041000000000000036, 0.044500000000000095], 'etasq': [0.18724499040394293, 0.18672787461986584, 0.1869545215311993, 0.18602234578410956, 0.18801076518536897, 0.18768536129994437, 0.18530190995240187, 0.18739465299106378, 0.1883470644147724, 0.18702726425136817], 'wasserstein': [0.4809417782846168, 0.4818821923335269, 0.48200928712295815, 0.4814291515004536, 0.48214270516207025, 0.48221691743325273, 0.4819922677768756, 0.48224229919880685, 0.48210069901959884, 0.48092641841630324], 'uf': [0.20074138061965174, 0.18903593307746047, 0.19367553764736045, 0.19637784279233078, 0.1994149227401605, 0.19587179915938607, 0.18342595512292942, 0.18961334911107464, 0.19138324160407472, 0.19211528100850683], 'tv': [0.08127209697244275, 0.0817088434930614, 0.07781748668928923, 0.08107849516790333, 0.07992613096715162, 0.07829710652517308, 0.07405758603669721, 0.07639552367368019, 0.07898884325022548, 0.07601498617123614]},
'fdami_linear_dp_7': {'precision': [0.7646459500764137, 0.7687179487179487, 0.7729145211122554, 0.7689549180327869, 0.7757009345794392, 0.7803983228511531, 0.7704580545548122, 0.7713257965056526, 0.7705338809034907, 0.7676560900716479], 'recall': [0.9993342210386151, 0.9980026631158455, 0.9993342210386151, 0.9993342210386151, 0.9946737683089214, 0.9913448735019973, 0.9966711051930759, 0.9993342210386151, 0.9993342210386151, 0.9986684420772304], 'auroc': [0.5358116888325606, 0.546190086578003, 0.5568960261819581, 0.5468558655393878, 0.5636019443954245, 0.5749897058273038, 0.5505443879379034, 0.55287996192493, 0.5508719297964161, 0.5435109278659244], 'dp': [0.01851113657880321, 0.008181393174380491, 0.02851802502035672, 0.024124115105058297, 0.03401699133270408, 0.04043690448524284, 0.013581762629574334, 0.019533158202184153, 0.02740539582644852, 0.011885866820575797], 'ftu': [0.01200000000000001, 0.000500000000000056, 0.020499999999999963, 0.0015000000000000568, 0.016000000000000014, 0.02100000000000002, 0.0035000000000000586, 0.01100000000000001, 0.019000000000000017, 0.0025000000000000577], 'etasq': [0.18632930281480553, 0.18630332768763525, 0.18543783022173055, 0.18790787935797879, 0.18680056928905325, 0.18669583495852374, 0.1884166764739502, 0.18713202518423733, 0.18638480068854532, 0.18800029574860702], 'wasserstein': [0.5329113313636767, 0.5334627429734934, 0.5336747030451486, 0.5336727975814017, 0.5327901510254974, 0.5322934719685793, 0.5326003435258824, 0.535216974444218, 0.5334710376819044, 0.5329628890694244], 'uf': [0.18905196310732988, 0.16660367776164373, 0.169612648491752, 0.1780671525417057, 0.17707477798971433, 0.17288876112469964, 0.16690415534707348, 0.17335737434945392, 0.15928685401206197, 0.1679531241615601], 'tv': [0.064706903836519, 0.05913320852435733, 0.06538630260457579, 0.06348206997349626, 0.06800896943171375, 0.061548718979113404, 0.054061360523812385, 0.057196571012414155, 0.051332525827163966, 0.05661184012746512]},
'fdami_linear_dp_8': {'precision': [0.7673824130879345, 0.7654258031616522, 0.7554101660795168, 0.7557905337361531, 0.7559134373427278, 0.7546505781799899, 0.756811301715439, 0.7573158425832492, 0.7588473205257836, 0.7574382249117498], 'recall': [0.9993342210386151, 0.9993342210386151, 0.9993342210386151, 0.9993342210386151, 1.0, 0.9993342210386151, 0.9986684420772304, 0.9993342210386151, 0.9993342210386151, 1.0], 'auroc': [0.5428398012823598, 0.5378197209610747, 0.5117153032903919, 0.512719319354649, 0.5130522088353413, 0.5097072711618779, 0.5153984780667276, 0.516735383611677, 0.5207514478687052, 0.5170682730923695], 'dp': [0.02825705860236727, 0.009560542309490438, 0.009003257087867311, 0.005800645301830887, 0.00044051603306727305, 0.0006301506998694917, 0.0037994521720123853, 0.00423366457944041, 0.008463008463008403, 0.0014519154462160344], 'ftu': [0.02100000000000002, 0.014499999999999957, 0.009000000000000008, 0.0010000000000000009, 0.0015000000000000568, 0.0040000000000000036, 0.0045000000000000595, 0.0020000000000000018, 0.015000000000000013, 0.0040000000000000036], 'etasq': [0.18822579234432055, 0.18557169153216557, 0.18601082579987735, 0.1871723683735419, 0.18726500948596644, 0.18761374782374834, 0.18446630886381982, 0.18744226991784327, 0.18597680448752707, 0.18755897795582108], 'wasserstein': [0.5745607389015928, 0.5750092590612226, 0.5740276173212507, 0.5751847408527168, 0.5751736389284028, 0.5745536244700402, 0.5733544928964498, 0.575616792329347, 0.5737111649235679, 0.5745135584758667], 'uf': [0.15711916421264005, 0.16338396809795513, 0.1561624650466117, 0.14137246921067956, 0.14975878936637227, 0.14928005826591328, 0.16093179607468536, 0.1432105595703497, 0.14800939723043774, 0.15562228578189805], 'tv': [0.04903465114871941, 0.04906504257717603, 0.043952828396228605, 0.04584985561888377, 0.04508931581440101, 0.04761309066048136, 0.05350793192775982, 0.048333504058276966, 0.04881357915576412, 0.05050024050024049]},
'fdami_linear_dp_9': {'precision': [0.753259779338014, 0.7520080321285141, 0.7527582748244734, 0.7521281922884326, 0.7525050100200401, 0.7556675062972292, 0.7540160642570282, 0.7536377320622177, 0.7521281922884326, 0.7525050100200401], 'recall': [1.0, 0.9973368841544608, 0.9993342210386151, 1.0, 1.0, 0.9986684420772304, 1.0, 1.0, 1.0, 1.0], 'auroc': [0.5060240963855422, 0.5026845063342584, 0.5046871908405928, 0.5030120481927711, 0.5040160642570282, 0.5123864298739566, 0.5080321285140562, 0.5070281124497992, 0.5030120481927711, 0.5040160642570282], 'dp': [5.888774636586547e-05, 0.0035530621785881955, 0.00024058035383822673, 6.044714923258976e-05, 0.002952029520295163, 0.0001564203864924396, 0.003497170175463138, 0.005189028910303928, 0.002133712660028486, 0.0007394848856503433], 'ftu': [0.008000000000000007, 0.0010000000000000009, 0.0014999999999999458, 0.0010000000000000009, 0.0020000000000000018, 0.0020000000000000018, 0.0024999999999999467, 0.0034999999999999476, 0.0040000000000000036, 0.0004999999999999449], 'etasq': [0.18756318119049858, 0.18681614029247448, 0.18597420833712539, 0.18617760840268233, 0.18816070689660322, 0.18752030276365936, 0.18720384371360374, 0.18893290867041246, 0.18720148076583357, 0.1883035329401687], 'wasserstein': [0.6070473512473764, 0.6063811184954949, 0.6045666191924299, 0.6079114612123726, 0.6072316536608862, 0.6074635755918399, 0.6066558153466758, 0.6079039143056135, 0.6059609847573537, 0.6076504755147699], 'uf': [0.12638909835081708, 0.1566216695712447, 0.1418689232241543, 0.14781602617319206, 0.1282301531106644, 0.13437268011255435, 0.144031234244648, 0.13822203469324476, 0.14371174983666332, 0.11486060255620356], 'tv': [0.03541404994773811, 0.04147235593421006, 0.03725155535489544, 0.038008785730393124, 0.038655331316185704, 0.03844570579864792, 0.03758292010688069, 0.0380872155743468, 0.03791361484281097, 0.03280900523088015]},
'fdami_linear_dp_10': {'precision': [0.7520040080160321, 0.7528879959819186, 0.7517517517517518, 0.7518796992481203, 0.7528822055137845, 0.7520040080160321, 0.7516274411617426, 0.751, 0.751, 0.7517517517517518], 'recall': [0.9993342210386151, 0.9980026631158455, 1.0, 0.9986684420772304, 1.0, 0.9993342210386151, 0.9993342210386151, 1.0, 1.0, 1.0], 'auroc': [0.5026791587120786, 0.5050254279434649, 0.5020080321285141, 0.5023462692313863, 0.5050200803212852, 0.5026791587120786, 0.5016751426478216, 0.5, 0.5, 0.5020080321285141], 'dp': [0.0007157126096783983, 0.009841047218326238, 0.0031645569620253333, 0.0031421112478458024, 0.0036900369003689537, 0.0007865710863619313, 0.0001418400137653819, 0.0, 0.0, 0.0007575211023735928], 'ftu': [0.000500000000000056, 0.01849999999999996, 0.0020000000000000018, 0.0024999999999999467, 0.0035000000000000586, 0.0010000000000000009, 0.0010000000000000009, 0.000500000000000056, 0.0004999999999999449, 0.0], 'etasq': [0.18861260429742752, 0.1858529344310261, 0.186943094977983, 0.187042610160657, 0.18593349800448664, 0.18755576747985983, 0.18627962057768221, 0.18680519995907965, 0.18572520580580287, 0.18580080872168492], 'wasserstein': [0.6333676799126841, 0.6313542022559633, 0.6319108556823047, 0.6322431357438174, 0.6311145810378499, 0.6322452939920864, 0.6315393642635134, 0.6318597429611891, 0.6317739473333912, 0.6321698686596143], 'uf': [0.13154289070057634, 0.0956318861091234, 0.1217531766114832, 0.12821999083638647, 0.11476212447251793, 0.1255411022759487, 0.1436893155015343, 0.12732101840183088, 0.118729502743157, 0.13236889631154838], 'tv': [0.03520100354476907, 0.024934215775259783, 0.032091176973882085, 0.03483458181869481, 0.034766983124733586, 0.03465411969936638, 0.03782981641788963, 0.035304909470212475, 0.03009430719402484, 0.035075231481481395]},
'fdami_linear_dp_11': {'precision': [0.7517517517517518, 0.7525050100200401, 0.7520040080160321, 0.751, 0.7521281922884326, 0.751, 0.7527582748244734, 0.751375687843922, 0.7554210791729703, 0.7523857358111502], 'recall': [1.0, 1.0, 0.9993342210386151, 1.0, 1.0, 1.0, 0.9993342210386151, 1.0, 0.9973368841544608, 0.9973368841544608], 'auroc': [0.5020080321285141, 0.5040160642570282, 0.5026791587120786, 0.5, 0.5030120481927711, 0.5, 0.5046871908405928, 0.501004016064257, 0.5117206509125718, 0.5036885223985156], 'dp': [0.0014903129657227732, 0.0005610098176718203, 0.0006107039751276355, 0.0, 0.0023627678137246866, 0.0, 0.0020415660997716856, 0.000741289844329085, 0.007301559933138857, 0.00679063559627735], 'ftu': [0.000500000000000056, 0.0, 0.0010000000000000009, 0.0, 0.0004999999999999449, 0.0004999999999999449, 0.0030000000000000027, 0.0010000000000000009, 0.00550000000000006, 0.0020000000000000018], 'etasq': [0.18689434078108438, 0.1877856418823911, 0.1880801593913779, 0.1868494035536263, 0.18665340906440114, 0.18714514224491713, 0.18712781017228022, 0.188094665667025, 0.18749589517845602, 0.18599373800910135], 'wasserstein': [0.6523121618831752, 0.6511972213510806, 0.6527880942347235, 0.6509772507477554, 0.6523181522392828, 0.6520863943513017, 0.6521074116236351, 0.6515740242143155, 0.65284231876734, 0.6509871986200881], 'uf': [0.10217849603893273, 0.11760362268436386, 0.10252242600708274, 0.10583136646754474, 0.09873418595568757, 0.12290528036511145, 0.09659116726992129, 0.1338225759657204, 0.11891376701889365, 0.12390873705709732], 'tv': [0.022716148866891328, 0.029580638837796713, 0.021412867300697247, 0.025815276110292218, 0.022609892369408247, 0.025748923867188078, 0.020802334098557473, 0.0338282685069774, 0.028858031376471693, 0.02609615500240503]},
'fdami_linear_dp_12': {'precision': [0.751503006012024, 0.7516307074761666, 0.7521281922884326, 0.751, 0.751, 0.751, 0.751, 0.751, 0.751, 0.751002004008016], 'recall': [0.9986684420772304, 0.9973368841544608, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9980026631158455], 'auroc': [0.5013422531671293, 0.5016804902700015, 0.5030120481927711, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5000053476221797], 'dp': [0.0015492007120887497, 0.0003973819541842616, 0.004746835443038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0037695692951446036], 'ftu': [0.000500000000000056, 0.0010000000000000009, 0.0034999999999999476, 0.0, 0.0, 0.0, 0.0010000000000000009, 0.0, 0.0, 0.0015000000000000568], 'etasq': [0.18814208738107063, 0.18644001556897463, 0.18785468816227832, 0.18567009407529073, 0.18693008942919914, 0.18614606633208644, 0.18653939094869842, 0.18809458152690442, 0.18764005868048483, 0.18528708671293453], 'wasserstein': [0.7601382430562043, 0.7579214692182172, 0.7593284805100093, 0.7594028296533193, 0.7601868656045176, 0.7581120990196215, 0.758134039393649, 0.761098847418016, 0.7581475559490151, 0.7580996698866792], 'uf': [0.037521759961153006, 0.045512151483355946, 0.0325554890920774, 0.0716781535435508, 0.07048109080057612, 0.038722668071733454, 0.041784855981316815, 0.04375790043331227, 0.041151852351016066, 0.033870671422143256], 'tv': [0.0014130141318803302, 0.0007817540115026, 0.0016818444068411598, 0.0030743637186563255, 0.0029386648034419594, 0.00244005384863466, 0.006293063301485602, 0.0007103743424549114, 0.0032544411432832154, 0.0002885627104377564]},
}

experiment_results_decaf ={
    'decaf': {'precision': [0.7544940934771444, 0.7516539440203562, 0.7537429013939081, 0.7515368852459017, 0.7525201612903226, 0.7478349465104432, 0.753822629969419, 0.7483341875961046, 0.7603053435114504, 0.7508878741755454], 'recall': [0.978029294274301, 0.9833555259653795, 0.9720372836218375, 0.9766977363515313, 0.9940079893475366, 0.9773635153129161, 0.9846870838881492, 0.9720372836218375, 0.9946737683089214, 0.9853528628495339], 'auroc': [0.5090949684222911, 0.50171792362526, 0.5071029791603163, 0.501401077011107, 0.5040321071235675, 0.4916938058492291, 0.50740378290793, 0.4930467542607179, 0.5244453178894005, 0.49970454387456614], 'dp': [0.042829752, 0.0014244914, 0.0029452443, 0.013480544, 0.0012477636, 0.004273653, 0.00066941977, 0.01544553, 0.0026813745, 0.0072214603], 'ftu': [0.037500024, 0.010500014, 0.0069999695, 0.0045000315, 0.009000003, 0.007999957, 0.0019999743, 0.021999955, 0.007000029, 0.012499988]}
}

def display_results(results):
    return np.array([np.round(np.mean(results), 3),  np.round(np.std(results), 3)])

df = pd.DataFrame(np.zeros((13, 2)),
                  columns=['mean', 'std'])
df['model'] = ['original', 'fdami_decaf_dp_1', 'fdami_decaf_dp_2', 'fdami_decaf_dp_3', 'fdami_decaf_dp_4', 'fdami_decaf_dp_5', 'fdami_decaf_dp_6', 'fdami_decaf_dp_7', 'fdami_decaf_dp_8', 'fdami_decaf_dp_9', 'fdami_decaf_dp_10', 'fdami_decaf_dp_11', 'fdami_decaf_dp_12']

df_linear = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
df_linear['model'] = ['fdami_linear_dp_1', 'fdami_linear_dp_2', 'fdami_linear_dp_3', 'fdami_linear_dp_4','fdami_linear_dp_5','fdami_linear_dp_6','fdami_linear_dp_7','fdami_linear_dp_8','fdami_linear_dp_9','fdami_linear_dp_10', 'fdami_linear_dp_11', 'fdami_linear_dp_12']


p_metric = 'precision'

df_decaf = pd.DataFrame(np.zeros((11, 2)),
                  columns=['mean', 'std'])
df_decaf['model'] = np.repeat('decaf', 11)


for model, model_results in experiment_results_decaf.items():
    df_decaf.loc[df_decaf['model'] == model, 'mean'] = display_results(model_results[p_metric])[0]
    df_decaf.loc[df_decaf['model'] == model, 'std'] = display_results(model_results[p_metric])[1]

df_decaf = df_decaf.transpose()

for model, model_results in experiment_results.items():
    df.loc[df['model'] == model, 'mean'] = display_results(model_results[p_metric])[0]
    df.loc[df['model'] == model, 'std'] = display_results(model_results[p_metric])[1]

df = df.transpose()

for model, model_results in experiment_results_linear.items():
    df_linear.loc[df_linear['model'] == model, 'mean'] = display_results(model_results[p_metric])[0]
    df_linear.loc[df_linear['model'] == model, 'std'] = display_results(model_results[p_metric])[1]

df_linear = df_linear.transpose()

eta_list = pd.DataFrame(np.zeros((12, 2)),
                  columns=['mean', 'std'])
eta_list['model'] = ['fdami_linear_dp_1', 'fdami_linear_dp_2', 'fdami_linear_dp_3', 'fdami_linear_dp_4','fdami_linear_dp_5','fdami_linear_dp_6','fdami_linear_dp_7','fdami_linear_dp_8','fdami_linear_dp_9','fdami_linear_dp_10', 'fdami_linear_dp_11', 'fdami_linear_dp_12']


for model, model_results in experiment_results_linear.items():
    eta_list.loc[eta_list['model'] == model, 'mean'] = display_results(model_results["etasq"])[0]
    eta_list.loc[eta_list['model'] == model, 'std'] = display_results(model_results["etasq"])[1]

eta_list = eta_list.transpose()
# eta_list.iloc[0,0] = 1
print(eta_list)

sig_list = np.sqrt([0, 0.25, 0.5, 0.75, 1, 1.25, 1.5, 1.75,  2, 2.25, 2.5, 2.75, 3])
fig, ax = plt.subplots(figsize=(7, 5))

ax.plot(1 / (sig_list ** 2 + 1), df.iloc[0,], 'o-r', label = 'FDA-DECAF', markersize = 4, color= 'red', marker = "s")
# ax.scatter(1 / (sig_list ** 2 + 1), df.iloc[0,], label = 'FDA-DECAF')
ax.fill_between(1 / (sig_list ** 2 + 1), df.iloc[0,].astype(float) - df.iloc[1,].astype(float), df.iloc[0,].astype(float) + df.iloc[1,].astype(float), alpha=.1, color = 'red')
# ax.errorbar(1 / (sig_list ** 2 + 1), df.iloc[0,], yerr=df.iloc[1,], label = "FDA-DECAF")

sig_list = np.arange(0.1, 1.1, 0.1)
sig_list = np.append(0.0001, sig_list)
sig_list = np.append(sig_list, 100000000)
ax.plot(eta_list.iloc[0,].astype(float) / (sig_list ** 2 + eta_list.iloc[0,].astype(float)), df_linear.iloc[0,], 'o-r', label = 'FDA-CMM', markersize = 4, color = 'blue', marker = "o")
ax.fill_between(eta_list.iloc[0,].astype(float) / (sig_list ** 2 + eta_list.iloc[0,].astype(float)), df_linear.iloc[0,].astype(float) - df_linear.iloc[1,].astype(float), df_linear.iloc[0,].astype(float) + df_linear.iloc[1,].astype(float), alpha=.1, color = "blue")
# ax.errorbar(eta_list.iloc[0,] / (sig_list ** 2 + eta_list.iloc[0,]), df_linear.iloc[0,], yerr=df_linear.iloc[1,], label = "FDA-CMM")
ax.plot(np.arange(0, 2.2, 0.2), df_decaf.iloc[0,], ':', label = 'DECAF', markersize = 4, color = 'purple')
ax.fill_between(np.arange(0, 2.2, 0.2), df_decaf.iloc[0,].astype(float) - df_decaf.iloc[1,].astype(float), df_decaf.iloc[0,].astype(float) + df_decaf.iloc[1,].astype(float), alpha=.1, color = "purple")
# ax.errorbar(eta_list.iloc[0,] / (sig_list ** 2 + eta_list.iloc[0,]), df_linear.iloc[0,], yerr=df_linear.iloc[1,], label = "FDA-CMM")


font_size = '18'
for n in ["top", "right"]:
    ax.spines[n].set_visible(False)
ax.set(xlim = (0, 1.05))
ax.set_xlabel(r"$\alpha$", fontsize = font_size)
if p_metric == 'wasserstein':
    ax.set_ylabel(r"$W_2^2(\mu_\hat{Y}, \mu_{Y})$", fontsize = font_size)


ax.set_title("")
if p_metric == 'precision':
    ax.set_ylabel('Precision', fontsize = font_size)
    ax.legend(loc = 'upper left', fontsize = font_size)
    # plt.yticks(np.arange(0.74, 0.98, 0.03))
elif p_metric == 'recall':
    ax.set_ylabel('Recall', fontsize = font_size)
    ax.legend(loc = 'lower left', fontsize = font_size)
elif p_metric == 'auroc':
    ax.set_ylabel('AUROC', fontsize = font_size)
    ax.legend(loc = 'upper left', fontsize = font_size)
elif p_metric == 'dp':
    ax.set_ylabel('DP', fontsize = font_size)
    ax.legend(loc = 'upper left', fontsize = font_size)

plt.xticks(fontsize = font_size) 
plt.yticks(fontsize = font_size) 
# plt.show()
model = 'combine'
plt.savefig(f'{model}_{p_metric}', pad_inches = 0.1)