## Installation and run
```
conda create -n py311 python=3.11                                                             
conda activate py311
pip install -e .
mv /home/ezipe/.miniconda3/compiler_compat/ld /home/ezipe/.miniconda3/compiler_compat/ld-backup
sudo apt install libopenmpi-dev gcc

pip install mpi4py

./make_dirs.sh
python run/gemini.py   
```


## Train base rewards
```python run/gemini.py --config '{"reward_from": "base"}' --wandb | tee base-01-28.log```


**A Decision-Language Model (DLM) for Dynamic Restless Multi-Armed Bandit Tasks in Public Health**
==================================

Restless multiarmed bandits (RMAB) have demonstrated success in public health resource allocation tasks, efficiently allocating 
limited health resources to large beneficiary populations. Unfortunately, RMAB models lack the necessary flexibility to adapt to
evolving public health policy priorities. Concurrently, Large Language Models (LLMs) have emerged as adept, automated planners in 
various domains, including robotic control and navigation. In this paper, we propose DLM: a Decision Language Model for RMABs. 
To enable dynamic fine-tuning of RMAB policies for challenging public health settings using human-language commands, we propose 
using LLMs as automated planners to (1) interpret human policy preference prompts, (2) propose code reward functions for a 
multi-agent RL environment for RMABs, and (3) iterate on the generated reward using feedback from RMAB simulations to effectively
 adapt policy outcomes. We illustrate the application of DLM in collaboration with ARMMAN, an India-based public health organization 
 promoting preventative care for pregnant mothers, that currently relies on RMAB policies for ensuring spread of important health 
 information to low resource populations. We conduct a simulation study using the Gemini Pro model, showing DLM can dynamically 
 shape policy outcomes using only human language commands as input.

## Setup

Main file for DLM, the main loop is `gemini.py`. ARMMAN environment removed from public code release. 

- Clone the repo:
- Install the repo:
- `pip3 install -e .`
- Create the directory structure:
- `bash make_dirs.sh`

Code adapted from https://github.com/killian-34/RobustRMAB, the github repo accompanying the paper "Restless and Uncertain: Robust Policies for Restless Bandits via Deep Multi-Agent Reinforcement Learning" in UAI 2023. 
