#!/bin/bash 
#SBATCH --job-name=pde-datagen
#SBATCH --output=OUTPUT-%j.out
#SBATCH --error=ERROR-%j.out
#SBATCH --time=240:00:00
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --mem=64G  
#SBATCH --partition=<Your Partition>
#SBATCH --account=<Your Account>
#SBATCH --qos=<Your QOS>

# Load required modules
module load Python3/3.11.2
module load cuda/12.4.1
source <'Path to the virtual environment'>

# Add OpenSSL to the path
export PATH=
export PATH=
export LD_LIBRARY_PATH=
export LC_ALL=
export LDFLAGS=

NUM_SAMPLES=<'Number of generated samples'>
CONFIG_PATH=<'Path to the config file'>
DATA_PATH=<'Path to the saving directory'>

seeds=(197910 452145 540788 61649 337293)
for SEED in ${seeds[*]};
do
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=train samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.005 \
    dirname=$DATA_PATH
done
seeds=(795028 806339 144207 415274 950547)
for SEED in ${seeds[*]};
do
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=train samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.010 \
    dirname=$DATA_PATH

    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=valid samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.010 \
    dirname=$DATA_PATH
done
seeds=(391920 891493 645944 403121 588319)
for SEED in ${seeds[*]};
do
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=train samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.015 \
    dirname=$DATA_PATH

    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=valid samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.015 \
    dirname=$DATA_PATH

    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=test samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.015 \
    dirname=$DATA_PATH
done
seeds=(431652 391355 600690 495919 874847)
for SEED in ${seeds[*]};
do
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=train samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.02 \
    dirname=$DATA_PATH
    
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=valid samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.02 \
    dirname=$DATA_PATH
    
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=test samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.02 \
    dirname=$DATA_PATH
done
seeds=(991570 597761 453345 349940 666497)
for SEED in ${seeds[*]};
do
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=valid samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.025 \
    dirname=$DATA_PATH
    
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=test samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.025 \
    dirname=$DATA_PATH
done
seeds=(856942 788627 234361 433043 153164)
for SEED in ${seeds[*]};
do 
    python pdemoe_train_scripts/generate_data_customized.py base=$CONFIG_PATH \
    experiment=smoke mode=test samples=$NUM_SAMPLES seed=$SEED pdeconfig.init_args.nu=0.030 \
    dirname=$DATA_PATH
done 