#!/bin/bash 
#SBATCH --job-name=pde-moe 
#SBATCH --output=OUTPUT-%j.out
#SBATCH --error=ERROR-%j.out
#SBATCH --time=240:00:00
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --mem=64G  
#SBATCH --partition=<Your Partition>
#SBATCH --account=<Your Account>
#SBATCH --qos=<Your QOS>

# Load required modules
module load Python3/3.11.2
module load cuda/12.4.1
source <'Path to the virtual environment'>

# Add OpenSSL to the path
export PATH=
export PATH=
export LD_LIBRARY_PATH=
export LC_ALL=
export LDFLAGS=  

#### Change MODEL to the following:
# (Included in the paper)
# FNO-128-8m 
# FNO-128-16m
# FNOs-128-16m
# FNOs-96-32m 
# FNOs-64-32m
# UNO-128
# UNO-64
# ResNet-256
# DilResNet-128 
# DilResNet-128-norm 
# ResNet-128
# Unetmod-64
# Unetmod-64-1x1

MODEL="<FILL IN MODEL NAME>"

python pdemoe_train_scripts/train_moe.py -c configs/navierstokes2d_test.yaml \
    --trainer.logger.init_args.name="<ANY NAME YOU LIKE>" \
    --data.data_dir="<PUT YOUR DATA DIR>" \
    --trainer.strategy=ddp --trainer.devices=1 \
    --trainer.max_epochs=50 \
    --data.batch_size=32 \
    --data.time_gap=0 --data.time_history=4 --data.time_future=1 \
    --model.name=$MODEL \
    --model.lr=2e-4 \
    --optimizer=AdamW --optimizer.lr=2e-4 --optimizer.weight_decay=1e-5 \
    --lr_scheduler=LinearWarmupCosineAnnealingLR \
    --lr_scheduler.warmup_epochs=5 \
    --lr_scheduler.max_epochs=50 --lr_scheduler.eta_min=1e-7   