from .grounder import BERT_Grounder
from .lifter import BERT_Lifter
from .signature import Signature
# import .translator
dirs = ["north", "south", "east", "west", "northwest", "northeast", "southwest", "southeast"]
nums = ["1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th"]
roads = ["street", "avenue"]
all_roads = [dir+"_"+num+"_"+road for dir in dirs for num in nums for road in roads]




TYPE_CONSTANTS = {
    "<search_and_rescue>": {
        "person": [
            "safe_civilian","safe_hostile","safe_person","safe_rescuer","safe_victim",
            "unsafe_civilian","unsafe_person","unsafe_rescuer","unsafe_victim",
            "injured_civilian","injured_hostile","injured_person","injured_rescuer",
            "injured_victim"
        ],
        "threat": [
            "active_debris","active_fire_source","active_flood","active_gas_leak",
            "active_unstable_beam","debris","fire_source","flood","gas_leak",
            "impending_debris","impending_fire_source","impending_flood",
            "impending_gas_leak","impending_unstable_beam","inactive_debris",
            "inactive_fire_source","inactive_flood","inactive_gas_leak",
            "inactive_unstable_beam","unstable_beam","nearest_fire_source",
            "nearest_flood","nearest_gas_leak","nearest_unstable_beam",
            "probable_debris","probable_fire_source","probable_flood",
            "probable_gas_leak","probable_unstable_beam","nearest_debris"
        ],
    },
    "<traffic_light>": {
        "light": [
            "light_east","light_north","light_south","light_west"
        ],
        "color": ["green","red","yellow"],
        "lane":   
            all_roads
        ,
        "traffic_target": [
            "car","collision","cyclist","motorcycle","pedestrian","person",
            "vehicle","jaywalker"
        ],
    },
    "<warehouse>": {
        "item": [
            "aeroplane","apple","backpack","banana","baseball_bat","baseball_glove",
            "bear","bed","bench","bicycle","bird","boat","book","bottle","bowl",
            "broccoli","bus","cake","car","carrot","cat","cell_phone","chair",
            "clock","cow","cup","dining_table","dog","donut","elephant",
            "fire_hydrant","fork","frisbee","giraffe","hair-drier","handbag",
            "horse","hot_dog","keyboard","kite","knife","laptop","microwave",
            "motorbike","mouse","orange","oven","parking_meter","person",
            "pizza","potted_plant","refrigerator","remote","sandwich","scissors",
            "sheep","sink","skateboard","skis","snowboard","sofa","spoon",
            "sports_ball","stop_sign","suitcase","surfboard","teddy-bear",
            "tennis_racket","tie","toaster","toilet","toothbrush","traffic_light",
            "train","truck","tv_monitor","umbrella","vase","wine_glass","zebra"
        ],
        "location": ["loading_dock","shelf"],
    },
}

search_and_rescue_signature = Signature(name="search_and_rescue",
                         sorts = ["person", "threat"],
                         preds = ["avoid", "communicate", "deliver_aid", "get_help", "go_home", "photo", "record"],
                         cons = TYPE_CONSTANTS["<search_and_rescue>"]
                         )
traffic_light_signature = Signature(name="traffic_light",
                         sorts = ["light", "color", "lane", "traffic_target"],
                         preds = ["change", "get_help", "photo", "record"],
                         cons = TYPE_CONSTANTS["<traffic_light>"]
                         )
warehouse_signature = Signature(name="warehouse",
                         sorts = ["item", "location"],
                         preds = ["deliver", "get_help", "idle", "pickup", "search"],
                         cons = TYPE_CONSTANTS["<warehouse>"]
                         )
__all__ = ['BERT_Lifter', 'BERT_Grounder', 'search_and_rescue_signature', 'traffic_light_signature', 'warehouse_signature']  
