import random

class Signature:
    def __init__(self, name, sorts, preds, cons):
        self.name = name
        self.sorts = sorts
        self.preds = preds
        self.cons = cons  # Dictionary mapping sort -> list of constants
        
        # Build reverse mapping: constant -> sort
        self.const_to_sort = {}
        for sort, constants in cons.items():
            for constant in constants:
                if constant in self.const_to_sort:
                    print(self.const_to_sort)
                    raise ValueError(f"Constant '{constant}' appears in multiple sorts.")
                self.const_to_sort[constant] = sort



    def get_dense_prefix(self):
        return [f'<{self.name}>'] + ['<types>'] + self.sorts + ['<predicates>'] + self.preds + ['<CTX>']

    def get_shuffled_dense_prefix(self):
        sorts = self.sorts.copy()
        preds = self.preds.copy()

        random.shuffle(sorts)
        random.shuffle(preds)

        return [f'<{self.name}>'] + ['<types>'] + sorts + ['<predicates>'] + preds + ['<CTX>']

    def get_full_prefix(self):
        return [f'<{self.name}>'] + ['<types>'] + self.sorts + ['<predicates>'] +self.preds + ['<constants>']+self.cons.items() ['<CTX>']


    def get_sort(self, constant):
        """Return the sort of a given constant."""
        return self.const_to_sort.get(constant, None)

    def __repr__(self):
        return f"<Signature(name={self.name}, sorts={self.sorts}, preds={self.preds})>"
