# KNO

## Usage 

You can install the requirements and the source code from the main directory using `pip install .` The requirements are listed in pyproject.toml. Change `jax[cpu]` to `jax[cuda12]` as necessary. Python 3.10.0 is used because in 3.11 there is some py-absl bug, but older versions should work fine. 

Place the datasets in the main directory. The Navier-Stokes dataset was ommited because of filesize. 

The experiments can be run by calling a [deploy_scripts](./deploy_scripts/) from the main directory. [config/darcy_pwc.py](./config/darcy_pwc.py) has descriptions for the experiment configs. 

### Quadrature rules

The quadrature rules are created directly in the [run](./run.py) file from code in the src folder. All the current 1d problems are in [0,1] and just use a plain gauss legendre rule with config.model.num_base_quad_points.

All the 2d problems that are in [0,1]^2 break up the domain into a triangular mesh based on config.model.num_domain_subdivisions_for_quad; i.e. if this is 1, the unit square will be cut across the diagonal, if this is 2, the unit square will be broken up into four smaller squares and those squares will be cut across the diagonal. Then the rule from the reference simplex is mapped to this mesh, 
totalling a num_subdivisions**2 * 3n^2 point quadrature rule. 

The Darcy triangular problem uses the reference simplex's rule, while the Triangular notch problem creates a Delaunay mesh for the domain. For the diffrec_3d problem on a sphere, I just load a quadrature rule from [datasets/sphere_quad](./datasets/sphere_quad/), which was created from [this](https://www.mathworks.com/matlabcentral/fileexchange/10750-quadrature-rules-for-spherical-volume-integrals) matlab code.

### Note on interpolation method

I have the kernel least squares interpolation scheme added here (able to be toggled on and off in the config files). It uses the hueristic of choosing the number of bases as sqrt(n_x), and having these centered at a random subset of x_grid (this is done in the run file), which hasn't been tested too much. It makes it so that we can use any kernel for any part of the model and everything works! Likely because before, the non-Wendland (non-smooth, non-compactly supported) kernels formed quite ill-conditioned interpolation operator matrices on the regularly spaced grids.

