import ml_collections


def get_config():
    config = ml_collections.ConfigDict()

    ### data
    config.data = data = ml_collections.ConfigDict()

    data.filepath = "datasets/darcy_pwc.npz"

    data.normalize = True
    data.ntrain = 1000
    data.ntest = 200

    ### model init
    config.model = model = ml_collections.ConfigDict()

    ### add choices to this in build_model.py
    model.activation = "gelu"

    ### quadrature stuff

    model.num_base_quad_pts = 6  ## for the 1D rule which will be mapped to the mesh
    model.num_domain_subdivisions_for_quad = 2  ## only for breaking up unit square into triangle mesh (this is ignored non-unit square problems). Set to one means 2 triangle mesh for the unit square, set to two means 4 triangle mesh, etc.

    ### int block stuff
    model.p = 32
    model.q = 16
    ### number of integration blocks, not including the last which evaluates the integral at y_grid.
    model.depth = 4

    ### interpolation scheme, either "kernel" or "kernel_least_squares"
    model.interpolation_scheme = "kernel"

    ### kernel stuff
    config.kernel = kernel = ml_collections.ConfigDict()

    ### currently only "spectral_mixture" or "wendland"
    kernel.eval_kernel = "spectral_mixture"
    kernel.integration_kernel = "wendland"
    kernel.interpolation_kernel = "wendland"
    kernel.add_product_kernel = False

    ### if a kernel has hyperparameters, add them via this pattern
    config.kernel.spectral_mixture = spectral_mixture = ml_collections.ConfigDict()
    spectral_mixture.q = 2  ### number of gaussians in the mixture

    ### training
    config.training = training = ml_collections.ConfigDict()
    training.batch_size = 20
    training.epochs = 15000
    training.log_at = 20  ### only log training loss every n epochs

    ### freeze training, uses 200 * (2 (int operator L and interpolant operator) + depth) epochs of training.epochs
    training.individual_layer_training = True
    training.epochs_per_layer = 200

    ### optimization
    config.optim = optim = ml_collections.ConfigDict()
    optim.optimizer = "adam"  ### "adam" or "sgd" easy to add more in run.py

    ### cos annealing params
    optim.init_value = 0.00075
    optim.warmup_frac = 0.3
    optim.peak_value = 0.00075
    optim.end_value = 0.00001
    optim.num_cosine_cycles = 5
    optim.num_constant_cycles = 1.5
    optim.gamma = 0.7

    ### testing
    config.testing = testing = ml_collections.ConfigDict()
    testing.eval_at = 100  ### eval test set every n epochs

    ### misc
    config.seed = 42
    config.dataset = "darcy_pwc"
    config.save_model = False

    return config
