import ml_collections


def get_config():
    config = ml_collections.ConfigDict()

    ### data
    config.data = data = ml_collections.ConfigDict()

    data.filepath = "datasets/darcy_triangular_notch.npz"

    data.normalize = True
    data.ntrain = 1900
    data.ntest = 100

    # model init
    config.model = model = ml_collections.ConfigDict()
    model.activation = "gelu"
    ### quadrature stuff
    model.num_base_quad_pts = 5  ## for the 1D rule which will be mapped to the mesh
    model.num_domain_subdivisions_for_quad = (
        None  ## only for breaking up unit square into triangle mesh
    )

    ### int block stuff
    model.p = 64
    model.q = 16
    model.depth = 4

    ### interpolation scheme, kernel/kernel_least_squares
    model.interpolation_scheme = "kernel"

    ### kernel stuff
    config.kernel = kernel = ml_collections.ConfigDict()

    kernel.eval_kernel = "spectral_mixture"
    kernel.integration_kernel = "spectral_mixture"
    kernel.interpolation_kernel = "wendland"
    kernel.add_product_kernel = False

    ### if a kernel has hyperparameters add them via this pattern
    config.kernel.spectral_mixture = spectral_mixture = ml_collections.ConfigDict()
    spectral_mixture.q = 2

    ### training
    config.training = training = ml_collections.ConfigDict()
    training.batch_size = 10
    training.epochs = 5000
    training.log_at = 20

    ### freeze training
    training.individual_layer_training = True
    training.epochs_per_layer = 100

    ### optimization
    config.optim = optim = ml_collections.ConfigDict()
    optim.optimizer = "adam"

    ### cos annealing params
    optim.init_value = 0.00003
    optim.warmup_frac = 0.3
    optim.peak_value = 0.0003
    optim.end_value = 0.00001
    optim.num_cosine_cycles = 5
    optim.num_constant_cycles = 1
    optim.gamma = 0.85

    ### testing
    config.testing = testing = ml_collections.ConfigDict()
    testing.eval_at = 100

    ### misc
    config.seed = 42
    config.dataset = "darcy_triangular_notch"
    config.save_model = False

    return config
