import ml_collections


def get_config():
    config = ml_collections.ConfigDict()

    # data preprocessing, not always used
    config.data = data = ml_collections.ConfigDict()

    data.filepath = "datasets/diffrec_3d.npz"

    data.normalize = True
    data.ntrain = 1000
    data.ntest = 200

    # model init
    config.model = model = ml_collections.ConfigDict()
    model.activation = "gelu"

    #### quadrature stuff ##############
    model.num_base_quad_pts = 5  ## for the 1D rule which will be mapped to the mesh
    config.model.num_subdivisions = (
        1  ## only for breaking up unit square into triangle mesh
    )

    #### int block stuff
    model.p = 64
    model.q = 64
    model.depth = 4

    ### interpolation scheme, kernel/kernel_least_squares
    model.interpolation_scheme = "kernel"

    ### kernel stuff
    config.kernel = kernel = ml_collections.ConfigDict()

    kernel.eval_kernel = "spectral_mixture"
    kernel.integration_kernel = "wendland"
    kernel.interpolation_kernel = "wendland"
    kernel.add_product_kernel = False

    ### if a kernel has hyperparameters add them via this pattern
    config.kernel.spectral_mixture = spectral_mixture = ml_collections.ConfigDict()
    spectral_mixture.q = 2

    # training
    config.training = training = ml_collections.ConfigDict()
    training.batch_size = 20
    training.epochs = 30000
    training.log_at = 20

    ### freeze training
    training.individual_layer_training = False
    training.epochs_per_layer = 500

    # optimization
    config.optim = optim = ml_collections.ConfigDict()
    optim.optimizer = "adam"
    ### cos annealing params
    optim.init_value = 0.00075
    optim.warmup_frac = 0.3
    optim.peak_value = 0.00075
    optim.end_value = 0.000005
    optim.num_cosine_cycles = 5
    optim.num_constant_cycles = 1.5
    optim.gamma = 0.6

    # testing
    config.testing = testing = ml_collections.ConfigDict()
    testing.eval_at = 100

    # misc
    config.seed = 42
    config.dataset = "diffrec_3d"
    config.save_model = False

    return config
