# nsfr
The implementation of the neuro-symbolic forward reasoner.
## main files
- predict.py: conduct the reasoning for kandinsky patterns from raw input images.
- predict_clevr.py: conduct the reasoning for CLEVR-Hans dataset from raw input images.
- predict_time.py: conduct time-comparison experiments on the kandinsky data sets
- vfcr.py: define the NS-FR model
- fcl.py: define the forward-chaining reasoning moduleß
- percept.py: define the perception module in NS-FR
- facts_converter.py: define the facts converter in NS-FR
- valuation.py: define a wrapper class of valuation function classes, to call valuation functions
- valuation_func.py: implement each valuation function for each neural predicate
- logic_utils.py: set of functions about symbolic logic
- neural_utils.py: set of functions and defining simple neural models
- data.py: definine the deataloader for kandinsky pattenrs data set
- data_clevr.py: define the dataloader for CLEVR-Hans data set
- train_cnn.py: train the baseline model of ResNet50 for Kandinsky data set
- train_yolo_mlp.py: train the baseline model of YOLO and MLP
- yolov5/: implementation of the yolov5 perception model
- slot_attention/: implementation of the slot attention perception module
- dilpst/ : the differentiable ILP implementation
- lang/define the first-oder logic expressions for each data set