## Installation
For complete installation instructions, please see [INSTALL.md](INSTALL.md).

## Usage
Static scene video generation given an image and a camera trajectory:

```bash
# You can utilize our CamPlanner class to freely construct the desired trajectory at line 13 in the `video_generate.py` file.
python video_generate.py --input_image_path ./assets/room.png --output_dir ./results-single-traj
```

A flexible-view 360° scene generation given an image.
```bash
# You are free to modify the corresponding YAML configuration file by name in `./configs/examples`.
python main_3dgs.py --name room2
```

## Dataset Preperation

1. Download dataset to local dir following [DL3DV repo](https://huggingface.co/datasets/DL3DV/DL3DV-ALL-960P). You may download only part of them, like 1K.

2. Prepare 3DGS from DL3DV dataset, you can first download colmap annotation from [DL3DV colmap annotation](https://huggingface.co/datasets/DL3DV/DL3DV-ALL-ColmapCache) and then do reconstruction following [Gaussian Splatting repo](https://github.com/graphdeco-inria/gaussian-splatting). The final output will listed like:
```
- output/
  - 001dccbc1f78146a9f03861026613d8e73f39f372b545b26118e37a23c740d5f
    - point_cloud
        - iteration_7000
            - point_cloud.ply
  - 0003dc82473fd52c53dcbdc2deb4e6e9c3548d6f8c9b03f9ea8d3c7d3ce33546
    - point_cloud
        - iteration_7000
            - point_cloud.ply
```

3. Run following to generate broken video constructed by 3DGS.
```bash
# The path here is an example.
python gen_dataset.py --dataset_path ./DL3DV/DL3DV-10K/1K --output_path ./DL3DV/processed --gs_path ./gaussian-splatting/output 
```

## Training 
1. Change following lines in "./tools/CogVideo/configs/sft_v2v.yaml".
```yaml
args:
  checkpoint_activations: True 
  experiment_name: lora-disney # your save folder name 
  mode: finetune
  load: "xxx/CogVideoX-5B-I2V-SAT/transformer" # path to transformer original checkpoints
  save: "./ckpts_5b" # path to save dir.
  train_data: [ "train_data_v2v" ] # Train data path
  valid_data: [ "train_data_v2v" ] # Validation data path, can be the same as train_data(no recommended)
```

2. Run training script
```bash
cd ./tools/CogVideo/
bash train_video_v2v.py
```