#%%
import matplotlib.pyplot as plt

# This is for the histogram of direcntion histogram across all the images
# the frequency of directions are extracted from the txt file in the output folder
qtype = "general_complex"
filepath = "/fs/scratch/PAS2099/Jiacheng/Orientation/output/answer_histo_v2.txt"

labels = []
counts = []

# Step 1: 读取 label 和 count
with open(filepath, "r") as f:
    for line in f:
        if ":" in line:
            label, count = line.strip().split(":")
            labels.append(label.strip())
            counts.append(int(count.strip()))

# Step 2: 绘制柱状图
plt.figure(figsize=(10, 5))
plt.bar(labels, counts, color="steelblue")

plt.title(f"Label Frequency for {qtype}", fontsize=14)
plt.xlabel("Label", fontsize=12)
plt.ylabel("Frequency", fontsize=12)

# 标签角度与样式
plt.xticks(rotation=30, fontsize=10, ha="right")
plt.tight_layout()
plt.grid(axis="y", linestyle="--", alpha=0.6)

# Step 3: 保存图片
output_path = "/fs/scratch/PAS2099/Jiacheng/Orientation/output/answer_histo"
plt.savefig(output_path, dpi=300, bbox_inches='tight')
plt.show()

print(f"✅ Saved label frequency plot to:\n{output_path}")

# %%
