import json

# === Load benchmark.json and extract general_complex entries ===
with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
    benchmark_data = json.load(f)

# Add "source": "val" and keep only first category name
general_complex_entries = [
    {
        **item,
        "source": "val",
        "category_name": item.get("category_name", "").split(",")[0].strip()
    }
    for item in benchmark_data
    if item.get("type") == "general_complex"
]

# === Load imagenet_train.json ===
with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/imagenet_train.json", "r") as f:
    imagenet_data = json.load(f)

# === Deduplicate by image, and convert to benchmark-style entries ===
seen_images = set()
converted_imagenet_entries = []

# Define the fixed question template (same as benchmark)
question_template = (
    "From the perspective of the camera, which orientation is the {category} in the photo facing? "
    "A.front B.front right C.right D.back right E.back F.back left G.left H.front left\n"
    "Answer with the option's letter and word from the given choices directly. "
    "Answer: [choose one in A.front B.front right C.right D.back right E.back F.back left G.left H.front left]"
)

for item in imagenet_data:
    image = item.get("image", "").strip()
    if image in seen_images:
        continue
    seen_images.add(image)

    category_clean = item.get("category_name", "").split(",")[0].strip()

    converted = {
        "type": "general_complex",
        "domain": "real",
        "base_dataset": "ImageNet_train",
        "image": "./imagenet_after/" + image,
        "original_label": item.get("direction", "").strip(),
        "question": question_template.format(category=category_clean),
        "label": item.get("direction", "").strip(),
        "category_name": category_clean,
        "source": "train"
    }
    converted_imagenet_entries.append(converted)

# === Combine and save ===
combined_data = general_complex_entries + converted_imagenet_entries

with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/combined_general_complex_fixed.json", "w") as f:
    json.dump(combined_data, f, indent=2)

print(f"✅ Merged dataset saved with {len(combined_data)} entries.")
