# import json
# from collections import defaultdict

# # === Define the 8 canonical directions ===
# DIRECTIONS = [
#     "front", "front right", "right", "back right",
#     "back", "back left", "left", "front left"
# ]

# # === Load benchmark.json ===
# with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
#     data = json.load(f)

# # === Build mapping structures: object → direction → image → items ===
# object_dir_to_image_to_items = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
# object_dir_image_sets = defaultdict(lambda: defaultdict(set))

# for item in data:
#     if item["type"] == "general_complex":
#         obj = item["category_name"].strip().lower()
#         label = item["label"].strip().lower()
#         image = item["image"].strip()

#         object_dir_image_sets[obj][label].add(image)
#         object_dir_to_image_to_items[obj][label][image].append(item)

# # === Filter: at least 3 directions, each direction has 6–18 images (truncate if >18)
# filtered_data = []
# valid_objects = []
# all_images = set()

# for obj in object_dir_image_sets:
#     label_map = object_dir_image_sets[obj]

#     # Only keep directions with at least 6 images
#     available_dirs = [d for d in DIRECTIONS if d in label_map and len(label_map[d]) >= 6]
#     if len(available_dirs) < 3:
#         continue

#     valid_objects.append(obj)

#     for direction in available_dirs:
#         image_list = list(label_map[direction])
#         if len(image_list) > 18:
#             image_list = image_list[:18]  # or random.sample(image_list, 18)

#         for image in image_list:
#             all_images.add(image)
#             filtered_data.extend(object_dir_to_image_to_items[obj][direction][image])

# # === Save filtered results to JSON file
# output_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_3dir_6to18perdir.json"
# with open(output_path, "w") as f:
#     json.dump(filtered_data, f, indent=2)

# # === Print result summary
# print(f"✅ Done! Saved {len(filtered_data)} entries to:\n{output_path}")
# print(f"🎯 Total valid objects (≥3 directions, each with 6–18 images): {len(valid_objects)}")
# print(f"🖼️  Total unique images: {len(all_images)}")

# keep 3 options, min: 6, max: 24
# import json
# from collections import defaultdict

# # === Define the 8 canonical directions ===
# DIRECTIONS = [
#     "front", "front right", "right", "back right",
#     "back", "back left", "left", "front left"
# ]

# # === Load benchmark.json ===
# with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
#     data = json.load(f)

# # === Build mapping structures: object → direction → image → items ===
# object_dir_to_image_to_items = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
# object_dir_image_sets = defaultdict(lambda: defaultdict(set))

# for item in data:
#     if item["type"] == "general_complex":
#         obj = item["category_name"].strip().lower()
#         label = item["label"].strip().lower()
#         image = item["image"].strip()

#         object_dir_image_sets[obj][label].add(image)
#         object_dir_to_image_to_items[obj][label][image].append(item)

# # === Filter: at least 3 directions, each direction has 6–24 images (truncate if >24)
# filtered_data = []
# valid_objects = []
# all_images = set()

# for obj in object_dir_image_sets:
#     label_map = object_dir_image_sets[obj]

#     # Only keep directions with at least 6 images
#     available_dirs = [d for d in DIRECTIONS if d in label_map and len(label_map[d]) >= 6]
#     if len(available_dirs) < 3:
#         continue

#     valid_objects.append(obj)

#     for direction in available_dirs:
#         image_list = list(label_map[direction])
#         if len(image_list) > 24:
#             image_list = image_list[:24]  # or random.sample(image_list, 24)

#         for image in image_list:
#             all_images.add(image)
#             filtered_data.extend(object_dir_to_image_to_items[obj][direction][image])

# # === Save filtered results to JSON file
# output_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_3dir_6to24perdir.json"
# with open(output_path, "w") as f:
#     json.dump(filtered_data, f, indent=2)

# # === Print result summary
# print(f"✅ Done! Saved {len(filtered_data)} entries to:\n{output_path}")
# print(f"🎯 Total valid objects (≥3 directions, each with 6–24 images): {len(valid_objects)}")
# print(f"🖼️  Total unique images: {len(all_images)}")

# import json
# from collections import defaultdict

# # === Define the 8 canonical directions ===
# DIRECTIONS = [
#     "front", "front right", "right", "back right",
#     "back", "back left", "left", "front left"
# ]

# # === Load benchmark.json ===
# with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
#     data = json.load(f)

# # === Build mapping structures: object → direction → image → items ===
# object_dir_to_image_to_items = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
# object_dir_image_sets = defaultdict(lambda: defaultdict(set))

# for item in data:
#     if item["type"] == "general_complex":
#         obj = item["category_name"].strip().lower()
#         label = item["label"].strip().lower()
#         image = item["image"].strip()

#         object_dir_image_sets[obj][label].add(image)
#         object_dir_to_image_to_items[obj][label][image].append(item)

# # === Filter: at least 3 directions, each direction has 4–16 images (truncate if >16)
# filtered_data = []
# valid_objects = []
# all_images = set()

# for obj in object_dir_image_sets:
#     label_map = object_dir_image_sets[obj]

#     # Only keep directions with at least 4 images
#     available_dirs = [d for d in DIRECTIONS if d in label_map and len(label_map[d]) >= 4]
#     if len(available_dirs) < 3:
#         continue

#     valid_objects.append(obj)

#     for direction in available_dirs:
#         image_list = list(label_map[direction])
#         if len(image_list) > 16:
#             image_list = image_list[:16]  # or use random.sample(image_list, 16)

#         for image in image_list:
#             all_images.add(image)
#             filtered_data.extend(object_dir_to_image_to_items[obj][direction][image])

# # === Save filtered results to JSON file
# output_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_3dir_4to16perdir.json"
# with open(output_path, "w") as f:
#     json.dump(filtered_data, f, indent=2)

# # === Print result summary
# print(f"✅ Done! Saved {len(filtered_data)} entries to:\n{output_path}")
# print(f"🎯 Total valid objects (≥3 directions, each with 4–16 images): {len(valid_objects)}")
# print(f"🖼️  Total unique images: {len(all_images)}")

import json
from collections import defaultdict

# === Define the 8 canonical directions ===
DIRECTIONS = [
    "front", "front right", "right", "back right",
    "back", "back left", "left", "front left"
]

# === Load benchmark.json ===
with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/combined_general_complex_fixed.json", "r") as f:
    data = json.load(f)

# === Build mapping structures: object → direction → image → items ===
object_dir_to_image_to_items = defaultdict(lambda: defaultdict(lambda: defaultdict(list)))
object_dir_image_sets = defaultdict(lambda: defaultdict(set))

for item in data:
    if item["type"] == "general_complex":
        obj = item["category_name"].strip().lower()
        label = item["label"].strip().lower()
        image = item["image"].strip()

        object_dir_image_sets[obj][label].add(image)
        object_dir_to_image_to_items[obj][label][image].append(item)

# === Filter: at least 3 directions, each direction has 10–30 images (truncate if >30)
filtered_data = []
valid_objects = []
all_images = set()

for obj in object_dir_image_sets:
    label_map = object_dir_image_sets[obj]

    # Only keep directions with at least 10 images
    available_dirs = [d for d in DIRECTIONS if d in label_map and len(label_map[d]) >= 10]
    if len(available_dirs) < 3:
        continue

    valid_objects.append(obj)

    for direction in available_dirs:
        image_list = list(label_map[direction])
        if len(image_list) > 50:
            image_list = image_list[:50]  # or use random.sample(image_list, 30)

        for image in image_list:
            all_images.add(image)
            filtered_data.extend(object_dir_to_image_to_items[obj][direction][image])

# === Save filtered results to JSON file
output_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_3dir_10to50perdir.json"
with open(output_path, "w") as f:
    json.dump(filtered_data, f, indent=2)

# === Print result summary
print(f"✅ Done! Saved {len(filtered_data)} entries to:\n{output_path}")
print(f"🎯 Total valid objects (≥3 directions, each with 10–50 images): {len(valid_objects)}")
print(f"🖼️  Total unique images: {len(all_images)}")

