#%%
import json
import os

# Step 1: 读取 benchmark.json
# with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
#     data = json.load(f)

with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_8_direction_filtered.json", "r") as f:
    data = json.load(f)
# Step 2: 提取每张图像的文件名 + object 类别
image_to_object = {}
for item in data:
    image_path = item["image"].strip()
    image_file = os.path.basename(image_path)
    category = item["category_name"].strip().lower()

    # 保证每张图片只算一次
    if image_file not in image_to_object:
        image_to_object[image_file] = category

# Step 3: 给每张图片分配编号，从 1 开始
id_to_object = {}
for i, (image_file, category) in enumerate(image_to_object.items(), start=1):
    id_to_object[i] = category

# Step 4: 保存结果到 TXT 文件（格式：1: object）
with open("id_to_object.txt", "w") as f:
    for id_, obj in id_to_object.items():
        f.write(f"{id_}: {obj}\n")

print("✅ 映射完成，保存为 id_to_object.txt")

# %%
