#%%
import json
from collections import Counter

# Step 1: 读取 benchmark.json
with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
    data = json.load(f)

# Step 2: 只统计 general_complex 类型中的 category_name
object_counter = Counter()

for item in data:
    if item["type"] == "general_complex":
        obj = item["category_name"].strip().lower()
        object_counter[obj] += 1

# Step 3: 写入到 txt 文件
with open("general_complex_object_counts.txt", "w") as f:
    for obj, count in object_counter.items():
        f.write(f"{obj}: {count}\n")

print("✅ 已将 object 计数写入 general_complex_object_counts.txt 文件")

# %%
