#%%
import json
from collections import Counter
# This is the code to get the txt file of objects and directions 

# Step 1: 读取 benchmark.json,注意修改json_path
json_path = "/fs/scratch/PAS2099/Jiacheng/Orientation/output/combined_general_complex_with_top_2devices_v2.json"
with open(json_path, "r") as f:
    data = json.load(f)

# Step 2: 只统计 general_complex 类型的 label
label_counter = Counter()

for item in data:
    if item["type"] == "general_complex":
        label = item["label"].strip().lower()
        label_counter[label] += 1

# get the direction: #images txt
output_path = "/fs/scratch/PAS2099/Jiacheng/Orientation/output/answer_histo_v2.txt"
with open(output_path, "w") as f:
    for label, count in label_counter.items():
        f.write(f"{label}: {count}\n")

print(f"✅ general_complex label count written to:\n{output_path}")




# # %%
# #%%
# import json
# from collections import defaultdict

# # 输入路径
# json_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json"
# # 输出路径
# output_txt_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/object_image_counts_20to80.txt"

# # object → set of image paths
# object_to_images = defaultdict(set)

# # 读取 JSON
# with open(json_path, "r") as f:
#     data = json.load(f)

# # 构建 object → 图像集合
# for item in data:
#     obj = item["category_name"].strip().lower()
#     image_path = item["image"].strip()
#     object_to_images[obj].add(image_path)

# # 写入结果
# with open(output_txt_path, "w") as f:
#     for obj in sorted(object_to_images.keys()):
#         f.write(f"{obj}: {len(object_to_images[obj])}\n")

# print(f"✅ Object-to-image count written to:\n{output_txt_path}")
# print(f"🎯 Total objects: {len(object_to_images)}")

# %%
