
# This is the code to get the object: #images histagram, it doesn't require the txt file
import json
import matplotlib.pyplot as plt
from collections import Counter

# Step 1: Load benchmark.json
with open("/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/EgoOrientBench/all_data/EgocentricDataset/train_benchmark/benchmark.json", "r") as f:
    data = json.load(f)

# Step 2: Count category_name for general_complex only
category_counter = Counter()

for item in data:
    if item["type"] == "general_complex":
        category = item["category_name"].strip().lower()
        category_counter[category] += 1

# Step 3: Prepare data for plotting
labels = list(category_counter.keys())
counts = list(category_counter.values())

# Step 4: Plot histogram
plt.figure(figsize=(12, 6))
plt.bar(labels, counts, color="steelblue")
plt.title("Number of general_complex Questions per Object Category", fontsize=14)
plt.xlabel("Object Category", fontsize=12)
plt.ylabel("Number of Questions", fontsize=12)
plt.xticks(rotation=45, ha="right")
plt.tight_layout()
plt.grid(axis='y', linestyle='--', alpha=0.6)
plt.show()

# %%
