#%%
import json

# === 输入 JSON 文件路径 ===
json_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_7dir_only.json"

# === 初始化两个集合：object types 和 images ===
object_types = set()
images = set()

# === 加载 JSON 并统计 ===
with open(json_path, "r") as f:
    data = json.load(f)

for item in data:
    if item["type"] == "general_complex":
        obj = item["category_name"].strip().lower()
        image = item["image"].strip()
        object_types.add(obj)
        images.add(image)

# === 输出结果 ===
print(f"🎯 Total number of unique object types: {len(object_types)}")
print(f"🖼️  Total number of unique images: {len(images)}")

# %%
