import json

# === Input & Output path (你可以替换为自己的路径) ===
input_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output/general_complex_combines_4dir_10to40perdir.json"
output_path = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output2/general_complex_combines_4dir_10to40perdir_with_top.json"

# === 加入 "I.top" 到 question 和 answer 字段 ===
def add_top_option(q_text: str) -> str:
    # 判断是否已包含 "I.top"
    if "I.top" in q_text or "top" in q_text.lower():
        return q_text  # 已有 top，不修改

    # 插入 I.top 到选项列表中（在 H.front left 后）
    q_text = q_text.replace(
        "H.front left",
        "H.front left I.top"
    )

    # 插入 I.top 到 Answer 部分
    q_text = q_text.replace(
        "[choose one in A.front B.front right C.right D.back right E.back F.back left G.left H.front left]",
        "[choose one in A.front B.front right C.right D.back right E.back F.back left G.left H.front left I.top]"
    )

    return q_text

# === Load JSON and modify questions ===
with open(input_path, "r") as f:
    data = json.load(f)

for item in data:
    if "question" in item:
        item["question"] = add_top_option(item["question"])

# === Save updated JSON ===
with open(output_path, "w") as f:
    json.dump(data, f, indent=2, ensure_ascii=False)

print(f"✅ Done! Saved with top option to: {output_path}")
