import json

# === Input file paths ===
file1 = "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/output2/general_complex_combines_4dir_10to40perdir_with_top.json"
file2 = "/fs/scratch/PAS2099/Jiacheng/Cure_or/output/cure_or_general_complex_2devices.json"

# === Output file path ===
output_file = "/fs/scratch/PAS2099/Jiacheng/Orientation/output/combined_general_complex_with_top_2devices_v2.json"

# === Load both JSON files ===
with open(file1, "r") as f1:
    data1 = json.load(f1)

with open(file2, "r") as f2:
    data2 = json.load(f2)

# === Combine them ===
combined = data1 + data2

# === Save the combined JSON ===
with open(output_file, "w") as f:
    json.dump(combined, f, indent=2, ensure_ascii=False)

print(f"✅ Combined {len(data1)} + {len(data2)} = {len(combined)} entries saved to:\n{output_file}")
