import os
import json

# === Paths ===
INPUT_JSON  = "/fs/scratch/PAS2099/Jiacheng/Orientation/train_v2/train.json"
OUTPUT_JSON = "/fs/scratch/PAS2099/Jiacheng/Orientation/train_v2/train_numbered.json"

# === Define the ordered orientation options ===
OPTIONS = [
    "front",
    "front right",
    "right",
    "back right",
    "back",
    "back left",
    "left",
    "front left",
    "top"
]

# === Load the existing train.json ===
with open(INPUT_JSON, "r") as f:
    data = json.load(f)

# === Update each entry so the GPT reply includes the numeric prefix ===
for entry in data:
    convs = entry.get("conversations", [])
    # find the 'gpt' part (assumed to be second)
    for msg in convs:
        if msg.get("from") == "gpt":
            label = msg.get("value", "").strip().lower()
            if label in OPTIONS:
                idx = OPTIONS.index(label) + 1
                msg["value"] = f"{idx}. {label}"
            break

# === Save the modified data ===
with open(OUTPUT_JSON, "w") as f:
    json.dump(data, f, indent=2, ensure_ascii=False)

print(f"✅ Wrote numbered answers to: {OUTPUT_JSON}")
