import os
import json

# === Paths ===
INPUT_JSON  = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val_ans.json"
OUTPUT_JSON = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val_ans_numbered.json"

# === Define the ordered orientation options ===
OPTIONS = [
    "front",
    "front right",
    "right",
    "back right",
    "back",
    "back left",
    "left",
    "front left",
    "top"
]

# === Load the existing val_ans.json ===
with open(INPUT_JSON, "r") as f:
    data = json.load(f)

# === Update each record's text to include the numeric prefix ===
for record in data:
    label = record.get("text", "").strip().lower()
    if label in OPTIONS:
        idx = OPTIONS.index(label) + 1
        record["text"] = f"{idx}. {label}"

# === Save the modified data ===
with open(OUTPUT_JSON, "w") as f:
    json.dump(data, f, indent=2, ensure_ascii=False)

print(f"✅ Wrote numbered answers to: {OUTPUT_JSON}")
